/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kr.co.goms.epub.solution.parts.EpubPreviewPart;
import kr.co.goms.epub.solution.registry.EditorRegistry;
import kr.co.goms.epub.solution.utils.ResourceUtil;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.undo.DocumentUndoManager;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.osgi.service.event.Event;

@Creatable
public class EpubEditorPart {
    private String filePath;
    @Inject
    private MPart part;
    @Inject
    EPartService partService;
    @Inject
    private MPart previewPart;
    private SourceViewer viewer;
    private Text text;
    @Inject
    private IEventBroker eventBroker;
    MDirtyable dirty;
    @Inject
    IEclipseContext context;
    @Inject
    EditorRegistry registry;
    private IFile currentFile;
    private AnnotationPainter highlightPainter;
    private final String H_ANN = "kr.co.goms.highlight";
    private final List<Annotation> liveHighlights = new ArrayList<Annotation>();
    private DocumentUndoManager docUndoMgr;
    private IUndoContext undoContext;
    private final IDocumentListener docListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (EpubEditorPart.this.dirty != null && !EpubEditorPart.this.dirty.isDirty()) {
                EpubEditorPart.this.dirty.setDirty(true);
            }
            String html = event.getDocument().get();
            EpubEditorPart.this.eventBroker.post("epub/html/updated", (Object)html);
        }
    };

    @PostConstruct
    public void createControls(Composite parent, final MDirtyable dirty) {
        parent.setLayout((Layout)new FillLayout());
        CompositeRuler leftRuler = new CompositeRuler();
        LineNumberRulerColumn lineNumbers = new LineNumberRulerColumn();
        lineNumbers.setForeground(Display.getCurrent().getSystemColor(16));
        leftRuler.addDecorator(0, (IVerticalRulerColumn)lineNumbers);
        this.viewer = new SourceViewer(parent, (IVerticalRuler)leftRuler, null, true, 2818);
        this.viewer.configure(new SourceViewerConfiguration());
        this.viewer.getTextWidget().setLayoutData((Object)new GridData(4, 4, true, true));
        Document empty = new Document("\n GomsBook Editor\uc5d0 \uc624\uc2e0 \uac83\uc744 \ud658\uc601\ud569\ub2c8\ub2e4!\n\n \uc804\uc790\ucc45 \uc81c\uc791\uc744 \uc704\ud55c \uc18c\uac1c \ud398\uc774\uc9c0\uc785\ub2c8\ub2e4.\n \uc67c\ucabd \ud0d0\uc0c9\uae30\uc5d0\uc11c \ud30c\uc77c\uc744 \uc120\ud0dd\ud558\uac70\ub098,\n \uc0c8 \ubb38\uc11c\ub97c \ub9cc\ub4e4\uc5b4 \uc9c1\uc811 \ub0b4\uc6a9\uc744 \ub9cc\ub4e4\uc5b4\ubcf4\uc138\uc694.\n\n GomsBook Editor\ub294 EPUB 3.0 \ud45c\uc900\uc744 \ub530\ub974\uba70,\n \ud45c\uc9c0/\uc800\uc790\uc18c\uac1c/\ubaa9\ucc28 \ud15c\ud50c\ub9bf\uacfc \uc804\uc790\ucc45 \uc624\ub958 \uac80\uc99d \uae30\ub2a5\uc744 \uc81c\uacf5\ud569\ub2c8\ub2e4.\n\n \ud83d\udc49 \uc9c0\uae08\ubd80\ud130 \ub2f9\uc2e0\ub9cc\uc758 \uc774\uc57c\uae30\ub97c \uc2dc\uc791\ud574 \ubcf4\uc138\uc694!\n\n \uac1c\ubc1c,\ub77c\uc774\uc120\uc2a4 \ub4f1 \ubb38\uc758 : omaro7@hanmail.net");
        this.viewer.setDocument((IDocument)empty, (IAnnotationModel)new AnnotationModel());
        DocumentUndoManagerRegistry.connect((IDocument)empty);
        this.docUndoMgr = (DocumentUndoManager)DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)empty);
        this.docUndoMgr.setMaximalUndoLevel(200);
        this.docUndoMgr.connect((Object)this.viewer);
        this.undoContext = this.docUndoMgr.getUndoContext();
        this.viewer.addTextInputListener(new ITextInputListener(){

            public void inputDocumentAboutToBeChanged(IDocument oldDoc, IDocument newDoc) {
                if (oldDoc != null) {
                    oldDoc.removeDocumentListener(EpubEditorPart.this.docListener);
                }
            }

            public void inputDocumentChanged(IDocument oldDoc, IDocument newDoc) {
                if (newDoc != null) {
                    newDoc.addDocumentListener(EpubEditorPart.this.docListener);
                }
            }
        });
        this.dirty = dirty;
        System.out.println("Dirty injected? " + (dirty != null));
        this.filePath = (String)this.part.getPersistedState().get("filePath");
        this.context.set(SourceViewer.class, (Object)this.viewer);
        this.currentFile = ResourceUtil.resolveIFile(this.filePath);
        this.registry.register(this.currentFile, this.viewer);
        this.part.getTransientData().put("currentFile", this.currentFile);
        this.viewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (dirty != null && !dirty.isDirty()) {
                    dirty.setDirty(true);
                }
                EpubEditorPart.this.eventBroker.post("epub/html/updated", (Object)event.getDocument().get());
            }
        });
        this.viewer.addTextInputListener(new ITextInputListener(){

            public void inputDocumentAboutToBeChanged(IDocument oldDoc, IDocument newDoc) {
                if (oldDoc != null) {
                    oldDoc.removeDocumentListener(EpubEditorPart.this.docListener);
                }
            }

            public void inputDocumentChanged(IDocument oldDoc, IDocument newDoc) {
                if (newDoc != null) {
                    newDoc.addDocumentListener(EpubEditorPart.this.docListener);
                }
            }
        });
        Object toOpen = this.part.getTransientData().get("fileToOpen");
        if (toOpen instanceof IFile) {
            IFile f = (IFile)toOpen;
            this.openFile(f);
        }
        final StyledText text = this.viewer.getTextWidget();
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x440000) != 0 && (e.keyCode == 97 || e.keyCode == 65)) {
                    text.selectAll();
                    e.doit = false;
                }
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean meta;
                boolean bl = meta = (e.stateMask & 0x440000) != 0;
                if (meta && (e.keyCode == 122 || e.keyCode == 90)) {
                    if ((e.stateMask & 0x20000) != 0) {
                        if (EpubEditorPart.this.viewer.canDoOperation(2)) {
                            EpubEditorPart.this.viewer.doOperation(2);
                        }
                    } else if (EpubEditorPart.this.viewer.canDoOperation(1)) {
                        EpubEditorPart.this.viewer.doOperation(1);
                    }
                    e.doit = false;
                } else if (meta && (e.keyCode == 121 || e.keyCode == 89)) {
                    if (EpubEditorPart.this.viewer.canDoOperation(2)) {
                        EpubEditorPart.this.viewer.doOperation(2);
                    }
                    e.doit = false;
                }
            }
        });
    }

    public String getCurrentHtml() {
        return this.text.getText();
    }

    public void setTextContent(String content) {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText(content);
        }
    }

    public void onTextChanged() {
        EpubPreviewPart preview;
        if (this.dirty != null) {
            this.dirty.setDirty(true);
        }
        String currentContent = this.text.getText();
        if (this.previewPart != null && (preview = (EpubPreviewPart)this.previewPart.getObject()) != null) {
            preview.setPreviewContent(currentContent);
        }
    }

    public void setXmlFilePath(String filePath) {
        this.filePath = filePath;
        try {
            String content = Files.readString(Paths.get(filePath, new String[0]));
            this.viewer.getDocument().set(content);
            this.part.setLabel(Paths.get(filePath, new String[0]).getFileName().toString());
            if (this.dirty != null) {
                this.dirty.setDirty(false);
            }
        }
        catch (IOException e) {
            this.viewer.getDocument().set("\ud30c\uc77c \uc5f4\uae30 \uc2e4\ud328: " + e.getMessage());
        }
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        this.loadFileContent();
    }

    private void loadFileContent() {
        if (this.filePath != null) {
            try {
                String content = Files.readString(Paths.get(this.filePath, new String[0]));
                Document doc = new Document(content);
                this.viewer.setDocument((IDocument)doc);
                this.part.setLabel(Paths.get(this.filePath, new String[0]).getFileName().toString());
                if (this.dirty != null) {
                    this.dirty.setDirty(false);
                }
            }
            catch (IOException e) {
                this.viewer.getTextWidget().setText("\ud30c\uc77c \uc5f4\uae30 \uc2e4\ud328: " + e.getMessage());
            }
        } else {
            this.viewer.getTextWidget().setText("filePath\uac00 \uc124\uc815\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
    }

    @Focus
    public void onFocus() {
        if (this.filePath == null || this.text == null) {
            return;
        }
        if (this.text == null || this.text.isDisposed()) {
            return;
        }
        this.text.setFocus();
        if (this.filePath == null || this.text == null) {
            return;
        }
        try {
            String content = Files.readString(Paths.get(this.filePath, new String[0]));
            this.text.setText(content);
            if (this.part != null) {
                this.part.setLabel(Paths.get(this.filePath, new String[0]).getFileName().toString());
            }
        }
        catch (IOException e) {
            this.text.setText("\ud30c\uc77c \uc5f4\uae30 \uc2e4\ud328: " + e.getMessage());
        }
    }

    @Persist
    public void save() {
        System.out.println("save() \ud638\ucd9c\ub428!");
        if (this.filePath == null) {
            return;
        }
        try {
            String content = this.viewer.getDocument().get();
            Files.writeString(Paths.get(this.filePath, new String[0]), (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            if (this.dirty != null) {
                this.dirty.setDirty(false);
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\uc800\uc7a5 \uc2e4\ud328", (String)("\ud30c\uc77c \uc800\uc7a5 \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage()));
        }
    }

    public void markDirty() {
        if (this.dirty != null) {
            this.dirty.setDirty(true);
        }
    }

    @Inject
    public void setLabel(MPart part) {
        part.setLabel("EPUB \ud3b8\uc9d1\uae30");
    }

    @PreDestroy
    public void dispose() {
        this.registry.unregister(this.currentFile);
    }

    public SourceViewer getSourceViewer() {
        return this.viewer;
    }

    public IFile getFile() {
        return this.currentFile;
    }

    public void openFile(IFile f) {
        String content = this.readAllAsString(f);
        this.setDocumentSafely(content);
        this.revealViewer();
        this.viewer.getControl().setFocus();
    }

    /*
     * Exception decompiling
     */
    private String readAllAsString(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void revealOnSourceViewer(SourceViewer viewer, int oneBasedLine, int oneBasedColumn) {
        if (viewer == null || viewer.getDocument() == null) {
            return;
        }
        try {
            int offset = this.safeOffset(viewer.getDocument(), oneBasedLine, oneBasedColumn);
            viewer.revealRange(offset, 1);
            viewer.setSelectedRange(offset, 1);
            if (viewer.getTextWidget() != null && !viewer.getTextWidget().isDisposed()) {
                viewer.getTextWidget().setFocus();
            }
        }
        catch (Exception exception) {}
    }

    private int safeOffset(IDocument doc, int oneBasedLine, int oneBasedColumn) throws BadLocationException {
        int lineIdx = Math.max(0, Math.min(oneBasedLine - 1, Math.max(0, doc.getNumberOfLines() - 1)));
        int lineOffset = doc.getLineOffset(lineIdx);
        int lineLen = doc.getLineLength(lineIdx);
        int col = Math.max(1, oneBasedColumn);
        int colOffset = Math.min(col - 1, Math.max(0, lineLen - 1));
        int offset = Math.max(0, Math.min(lineOffset + colOffset, Math.max(0, doc.getLength() - 1)));
        return offset;
    }

    public static String convertToProjectPath(String pathStr, String projectFullPath) {
        String normPath = pathStr.replace("\\", "/");
        String normProject = projectFullPath.replace("\\", "/");
        int idx = normPath.indexOf("/OEBPS/");
        if (idx == -1) {
            return normPath;
        }
        String subPath = normPath.substring(idx);
        return normProject + subPath;
    }

    public void highlightAtLineCol(int oneBasedLine, int oneBasedCol, int length, int autoClearMs) {
        System.out.println("highlightAtLineCol \uc2dc\uc791\ud569\ub2c8\ub2e4.");
        System.out.println("line : " + oneBasedLine);
        System.out.println("col : " + oneBasedCol);
        IDocument doc = this.viewer.getDocument();
        if (doc == null) {
            return;
        }
        System.out.println("doc.get() : " + doc.get());
        try {
            int lineIdx = Math.max(0, Math.min(oneBasedLine - 1, Math.max(0, doc.getNumberOfLines() - 1)));
            int lineOffset = doc.getLineOffset(lineIdx);
            int lineLen = doc.getLineLength(lineIdx);
            int col = Math.max(1, oneBasedCol);
            int colOffset = Math.min(col - 1, Math.max(0, lineLen - 1));
            int offset = Math.max(0, Math.min(lineOffset + colOffset, Math.max(0, doc.getLength() - 1)));
            int len = Math.max(1, Math.min(length, Math.max(1, doc.getLength() - offset)));
            IAnnotationModel model = this.viewer.getAnnotationModel();
            if (model == null) {
                return;
            }
            this.clearHighlights(model);
            Annotation ann = new Annotation("kr.co.goms.highlight", false, "epubcheck \uc704\uce58");
            Position pos = new Position(offset, len);
            if (model instanceof IAnnotationModelExtension) {
                IAnnotationModelExtension ext = (IAnnotationModelExtension)model;
                ext.replaceAnnotations(null, Map.of(ann, pos));
            } else {
                model.addAnnotation(ann, pos);
            }
            this.liveHighlights.add(ann);
            this.viewer.revealRange(offset, len);
            this.viewer.setSelectedRange(offset, 0);
            if (this.viewer.getTextWidget() != null && !this.viewer.getTextWidget().isDisposed()) {
                this.viewer.getTextWidget().setFocus();
            }
            if (autoClearMs > 0) {
                Display.getDefault().timerExec(autoClearMs, () -> {
                    IAnnotationModel m = this.viewer.getAnnotationModel();
                    if (m != null && !this.viewer.getTextWidget().isDisposed()) {
                        this.clearHighlights(m);
                    }
                });
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void clearHighlights(IAnnotationModel model) {
        if (this.liveHighlights.isEmpty()) {
            return;
        }
        if (model instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ext = (IAnnotationModelExtension)model;
            ext.replaceAnnotations(this.liveHighlights.toArray(new Annotation[0]), null);
        } else {
            for (Annotation a : this.liveHighlights) {
                model.removeAnnotation(a);
            }
        }
        this.liveHighlights.clear();
    }

    private void setDocumentSafely(String text) {
        if (!Display.getCurrent().equals(Display.getDefault())) {
            Display.getDefault().asyncExec(() -> this.setDocumentSafely(text));
            return;
        }
        IDocument oldDoc = this.viewer.getDocument();
        if (oldDoc != null && this.docListener != null) {
            oldDoc.removeDocumentListener(this.docListener);
        }
        if (oldDoc != null) {
            try {
                DocumentUndoManagerRegistry.disconnect((IDocument)oldDoc);
            }
            catch (Exception exception) {}
        }
        Document newDoc = new Document(text);
        AnnotationModel newAnno = new AnnotationModel();
        DocumentUndoManagerRegistry.connect((IDocument)newDoc);
        this.docUndoMgr = (DocumentUndoManager)DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)newDoc);
        this.docUndoMgr.setMaximalUndoLevel(200);
        this.undoContext = this.docUndoMgr.getUndoContext();
        if (this.docListener != null) {
            newDoc.addDocumentListener(this.docListener);
        }
        this.viewer.setDocument((IDocument)newDoc, (IAnnotationModel)newAnno);
    }

    private void revealViewer() {
        Control c = this.viewer.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        Composite parent = c.getParent();
        Layout layout = parent.getLayout();
        if (layout instanceof StackLayout) {
            StackLayout sl = (StackLayout)layout;
            sl.topControl = c;
            parent.layout(true, true);
        } else {
            c.setVisible(true);
            parent.layout(true, true);
        }
    }

    private void closeCurrentFileViewOnly() {
        this.setDocumentSafely("");
    }

    public void selectAll() {
        if (this.viewer != null && this.viewer.getTextWidget() != null && !this.viewer.getTextWidget().isDisposed()) {
            this.viewer.getTextWidget().selectAll();
        }
    }

    public void undo() {
        if (this.viewer != null && this.viewer.canDoOperation(1)) {
            this.viewer.doOperation(1);
        }
    }

    public void redo() {
        if (this.viewer != null && this.viewer.canDoOperation(2)) {
            this.viewer.doOperation(2);
        }
    }

    public void requestClose() {
        System.out.println("requestClose()");
        boolean ok = this.partService.savePart(this.part, true);
        if (!ok) {
            return;
        }
        this.partService.hidePart(this.part, true);
    }

    @PreDestroy
    void onClose() {
        System.out.println("Editor closed: " + this.filePath);
        if (this.docUndoMgr != null) {
            try {
                this.docUndoMgr.disconnect((Object)"kr.co.goms.highlight");
            }
            catch (Exception exception) {}
        }
    }

    @Inject
    @Optional
    public void onToBeRendered(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*") Event ev) {
        MPart part;
        Object changed = ev.getProperty("ChangedElement");
        Object newVal = ev.getProperty("NewValue");
        if (changed instanceof MPart && (part = (MPart)changed).getTags().contains("Editor") && Boolean.FALSE.equals(newVal)) {
            System.out.println("Editor toBeRendered=false: " + part.getElementId());
        }
    }

    @Inject
    @Optional
    public void onOpfUpdated(@UIEventTopic(value="gomsbook/opf/updated") Map<String, Object> data) {
        IFile changed = (IFile)data.get("file");
        if (changed == null) {
            return;
        }
        if (!changed.equals((Object)this.currentFile)) {
            return;
        }
        Display.getDefault().asyncExec(() -> this.reloadDocument(changed));
    }

    private void reloadDocument(IFile file) {
        if (this.viewer == null || this.viewer.getTextWidget() == null || this.viewer.getTextWidget().isDisposed()) {
            return;
        }
        IDocument doc = this.viewer.getDocument();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = file.getContents(true);){
                String charset = "UTF-8";
                try {
                    charset = file.getCharset(true);
                }
                catch (Exception exception) {}
                String newText = new String(is.readAllBytes(), charset);
                doc.set(newText);
                if (this.dirty != null) {
                    this.dirty.setDirty(false);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.viewer.getTextWidget().getShell(), (String)"\uc7ac\ub85c\ub529 \uc624\ub958", (String)e.getMessage());
        }
    }
}

