/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.co.goms.epub.solution.parts.EpubEditorPart;
import kr.co.goms.epub.solution.parts.EpubPreviewPart;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EpubOpfSpinePart {
    @Inject
    private EMenuService menuService;
    private TableViewer viewer;
    private IFile currentOpf;
    private IFile currentNcx;
    private List<OpfItem> spineItems = new ArrayList<OpfItem>();
    private Map<TableItem, TableEditor> editorMap = new HashMap<TableItem, TableEditor>();
    int operations = 2;
    Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
    @Inject
    @Optional
    private MApplication application;
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    @Optional
    private MDirtyable dirty;

    @PostConstruct
    public void createComposite(Composite parent, EPartService partService) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Color backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
        this.viewer = new TableViewer(parent, 67586);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderBackground(backgroundColor);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.createColumns();
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.addDragSupport(this.operations, this.transferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                event.data = EpubOpfSpinePart.this.viewer.getSelection();
            }

            public void dragStart(DragSourceEvent event) {
                event.doit = !EpubOpfSpinePart.this.viewer.getSelection().isEmpty();
                LocalSelectionTransfer.getTransfer().setSelection(EpubOpfSpinePart.this.viewer.getSelection());
            }
        });
        this.viewer.addDropSupport(this.operations, this.transferTypes, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){

            public boolean performDrop(Object data) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                if (selection == null || selection.isEmpty()) {
                    return false;
                }
                Object dragged = selection.getFirstElement();
                if (!(dragged instanceof OpfItem)) {
                    return false;
                }
                OpfItem draggedItem = (OpfItem)dragged;
                int targetIndex = EpubOpfSpinePart.this.spineItems.size();
                Object target = this.getCurrentTarget();
                if (target instanceof OpfItem) {
                    int index = EpubOpfSpinePart.this.spineItems.indexOf(target);
                    if (this.getCurrentLocation() == 1) {
                        targetIndex = index;
                    } else if (this.getCurrentLocation() == 2) {
                        targetIndex = index + 1;
                    }
                }
                EpubOpfSpinePart.this.spineItems.remove(draggedItem);
                if (targetIndex > EpubOpfSpinePart.this.spineItems.size()) {
                    targetIndex = EpubOpfSpinePart.this.spineItems.size();
                }
                EpubOpfSpinePart.this.spineItems.add(targetIndex, draggedItem);
                EpubOpfSpinePart.this.viewer.refresh();
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }
        });
        this.loadOpfFromActiveEditor();
        this.menuService.registerContextMenu((Object)this.viewer.getControl(), "kr.co.goms.epub.solution.parts.EpubOpfSpinePart");
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        buttonComposite.setLayout((Layout)new RowLayout(256));
        Button previewButton = new Button(buttonComposite, 8);
        previewButton.setText("\ud30c\uc77c\ubcf4\uae30");
        previewButton.addListener(13, e -> this.previewOpf());
        Button saveButton = new Button(buttonComposite, 8);
        saveButton.setText("\uc800\uc7a5\ud558\uae30");
        saveButton.addListener(13, e -> this.saveOrder());
    }

    private void createColumns() {
        String[] titles = new String[]{"ID", "Href", "Media Type", "Linear"};
        int[] widths = new int[]{120, 200, 200, 80};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn col = new TableViewerColumn(this.viewer, 0x1000000);
            col.getColumn().setText(titles[i]);
            col.getColumn().setWidth(widths[i]);
            col.getColumn().setResizable(true);
            final int index = i++;
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    OpfItem item = (OpfItem)element;
                    return switch (index) {
                        case 0 -> item.id;
                        case 1 -> item.href;
                        case 2 -> item.mediaType;
                        case 3 -> item.linear;
                        default -> "";
                    };
                }
            });
        }
    }

    private void moveUp(OpfItem item) {
        int index = this.spineItems.indexOf(item);
        if (index > 1) {
            this.spineItems.remove(index);
            this.spineItems.add(index - 1, item);
            this.viewer.refresh();
            this.dirty.setDirty(true);
        }
    }

    private void moveDown(OpfItem item) {
        int index = this.spineItems.indexOf(item);
        if (index < this.spineItems.size() - 1) {
            this.spineItems.remove(index);
            this.spineItems.add(index + 1, item);
            this.viewer.refresh();
            this.dirty.setDirty(true);
        }
    }

    private void loadOpfFromActiveEditor() {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Text");
        IFile file = iFolder.getProject().getFile("OEBPS/content.opf");
        System.out.println("file : " + String.valueOf(file));
        if (file != null) {
            this.currentOpf = file;
            this.refresh();
        }
    }

    private void refresh() {
        if (this.currentOpf == null) {
            return;
        }
        System.out.println("refresh() : " + String.valueOf(this.currentOpf));
        try {
            this.spineItems.clear();
            Document doc = OpfNcxUpdater.loadXml(this.currentOpf);
            Element manifest = (Element)doc.getElementsByTagName("manifest").item(0);
            Element spine = (Element)doc.getElementsByTagName("spine").item(0);
            HashMap<String, Element> manifestMap = new HashMap<String, Element>();
            NodeList manifestItems = manifest.getElementsByTagName("item");
            int i = 0;
            while (i < manifestItems.getLength()) {
                Element item = (Element)manifestItems.item(i);
                manifestMap.put(item.getAttribute("id"), item);
                ++i;
            }
            NodeList refs = spine.getElementsByTagName("itemref");
            int i2 = 0;
            while (i2 < refs.getLength()) {
                String idref = ((Element)refs.item(i2)).getAttribute("idref");
                String linear = ((Element)refs.item(i2)).getAttribute("linear");
                Element manifestItem = (Element)manifestMap.get(idref);
                if (manifestItem != null) {
                    this.spineItems.add(new OpfItem(idref, manifestItem.getAttribute("href"), manifestItem.getAttribute("media-type"), linear, true));
                }
                ++i2;
            }
            this.viewer.setInput(this.spineItems);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isExclude(String name) {
        String lower = name.toLowerCase();
        return lower.equals("cover_xhtml") || lower.endsWith("publisher_xhtml") || lower.endsWith("copyright_xhtml") || lower.endsWith("nav_xhtml");
    }

    public void addItem() {
        if (this.currentOpf == null) {
            return;
        }
        InputDialog dlg = new InputDialog(this.viewer.getTable().getShell(), "Add", "Enter href:", "", null);
        if (dlg.open() == 0) {
            try {
                String href = dlg.getValue();
                String id = "item" + System.currentTimeMillis();
                String type = OpfNcxUpdater.getMediaType(href);
                boolean isXhtml = href.endsWith(".xhtml");
                boolean addToScripted = true;
                boolean addToLinearNo = false;
                OpfNcxUpdater.addFileToOpf(this.currentOpf, id, href, type, isXhtml, addToScripted, addToLinearNo);
                if (this.currentNcx.exists()) {
                    int order = (int)(System.currentTimeMillis() % 100000L);
                    OpfNcxUpdater.addNavPointToNcx(this.currentNcx, id, href, order);
                }
                this.refresh();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void removeItem() {
        try {
            IStructuredSelection sel = this.viewer.getStructuredSelection();
            Object elem = sel.getFirstElement();
            if (elem instanceof OpfItem) {
                OpfItem it = (OpfItem)elem;
                OpfNcxUpdater.removeFileFromOpf(this.currentOpf, it.id, it.href);
                if (this.currentNcx.exists()) {
                    OpfNcxUpdater.removeNavPointFromNcx(this.currentNcx, it.href);
                }
                this.refresh();
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveOrder() {
        try {
            Document doc = OpfNcxUpdater.loadXml(this.currentOpf);
            Element spine = (Element)doc.getElementsByTagName("spine").item(0);
            NodeList refs = spine.getElementsByTagName("itemref");
            while (refs.getLength() > 0) {
                spine.removeChild(refs.item(0));
            }
            for (OpfItem it : this.spineItems) {
                Element ir = doc.createElement("itemref");
                ir.setAttribute("idref", it.id);
                spine.appendChild(ir);
            }
            OpfNcxUpdater.saveXml(this.currentOpf, doc);
            this.spineItems.clear();
            this.refresh();
            MessageDialog.openInformation((Shell)this.viewer.getTable().getShell(), (String)"\uc800\uc7a5\ub428", (String)"Spine \uc21c\uc11c\uac00 \uc800\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void previewOpf() {
        Object object;
        System.out.println("filePath editorId : kr.co.goms.epub.solution.parts.epubeditorpart");
        System.out.println("partService : " + String.valueOf(this.partService));
        String filePath = EpubBuildUtil.getProjectPath() + this.currentOpf.getFullPath().toString();
        System.out.println("filePath : " + filePath);
        String editorId = "kr.co.goms.epub.solution.parts.epubeditorpart";
        for (MPart part : this.partService.getParts()) {
            String openedPath;
            if (!editorId.equals(part.getElementId()) || !this.currentOpf.equals((Object)(openedPath = (String)part.getPersistedState().get("filePath")))) continue;
            this.partService.showPart(part, EPartService.PartState.ACTIVATE);
            EpubEditorPart editor = (EpubEditorPart)part.getObject();
            editor.onFocus();
            if (editor != null) {
                editor.setFilePath(filePath);
            }
            return;
        }
        MPart editorPart = this.partService.createPart(editorId);
        editorPart.setElementId(editorId);
        editorPart.setContributionURI("bundleclass://epubtest03/kr.co.goms.epub.solution.parts.EpubEditorPart");
        editorPart.getPersistedState().put("filePath", filePath);
        editorPart.getTags().add("Editor");
        String partStackId = "kr.co.goms.epub.solution.parts.editpartstack";
        MPartStack partStack = (MPartStack)this.modelService.find(partStackId, (MUIElement)this.application);
        if (partStack != null) {
            partStack.getChildren().add(editorPart);
            this.partService.showPart(editorPart, EPartService.PartState.ACTIVATE);
        } else {
            System.out.println("PartStack with ID " + partStackId + " not found.");
        }
        MPart previewPart = this.partService.showPart("kr.co.goms.epub.solution.parts.previewpart", EPartService.PartState.VISIBLE);
        if (previewPart != null && (object = previewPart.getObject()) instanceof EpubPreviewPart) {
            EpubPreviewPart preview = (EpubPreviewPart)object;
            preview.setPreviewContent(filePath);
        }
    }

    static class OpfItem {
        String id;
        String href;
        String mediaType;
        String linear;
        boolean inSpine;

        OpfItem(String i, String h, String m, String linear, boolean s) {
            this.id = i;
            this.href = h;
            this.mediaType = m;
            this.linear = linear;
            this.inSpine = s;
        }
    }

    static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object e, int col) {
            OpfItem it = (OpfItem)e;
            return switch (col) {
                case 0 -> it.id;
                case 1 -> it.href;
                case 2 -> it.mediaType;
                case 3 -> it.linear;
                default -> "";
            };
        }

        public Image getColumnImage(Object o, int c) {
            return null;
        }
    }
}

