/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kr.co.goms.epub.managers.EpubPartManager;
import kr.co.goms.epub.solution.dialogs.EpubViewerDialog;
import kr.co.goms.epub.solution.jobs.EpubCheckJob;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.providers.TableLabelProvider;
import kr.co.goms.epub.solution.ui.EpubItem;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressConstants;

public class EpubTableViewerPart {
    private TableViewer tableViewer;
    private boolean sortAscending = true;
    private Text searchText;
    private List<File> allEpubFiles = new ArrayList<File>();
    private Color backgroundColor;
    private List<TableEditor> editors = new ArrayList<TableEditor>();
    @Inject
    private EPartService partService;
    @Inject
    IEclipseContext context;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;

    @PostConstruct
    public void createControls(Composite parent) {
        Shell shell = parent.getShell();
        this.partService = (EPartService)this.context.get(EPartService.class);
        this.backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
        parent.setLayout((Layout)new GridLayout(1, false));
        this.searchText = new Text(parent, 2944);
        this.searchText.setMessage("\ud30c\uc77c\uba85 \uac80\uc0c9...");
        this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchText.addModifyListener(e -> this.applyFilter(shell));
        this.tableViewer = new TableViewer(parent, 68096);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderBackground(this.backgroundColor);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        String[] titles = new String[]{"No", "EPUB", "Date", "\uc5f4\uae30", "\uac80\uc99d"};
        int[] widths = new int[]{40, 260, 160, 80, 80};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0x1000000);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            column.setResizable(false);
            column.setMoveable(false);
            ++i;
        }
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selected = selection.getFirstElement();
                if (selected instanceof File) {
                    File epubFile = (File)selected;
                    Shell shell = Display.getDefault().getActiveShell();
                    EpubViewerDialog dialog = new EpubViewerDialog(shell, epubFile);
                    Color backgroundColor = new Color((Device)shell.getDisplay(), 220, 235, 250);
                    dialog.setTitleAreaColor(backgroundColor.getRGB());
                    dialog.open();
                }
            }
        });
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 10;
        rowLayout.center = true;
        buttonComposite.setLayout((Layout)rowLayout);
        Button reloadButton = new Button(buttonComposite, 8);
        reloadButton.setText("Reload");
        reloadButton.addListener(13, e -> this.refreshTree(shell));
        Button sortButton = new Button(buttonComposite, 8);
        sortButton.setText("Sort: ASC");
        sortButton.addListener(13, e -> {
            this.sortAscending = !this.sortAscending;
            sortButton.setText(this.sortAscending ? "Sort: ASC" : "Sort: DESC");
            this.refreshTree(shell);
        });
        this.refreshTree(shell);
    }

    private void setTitleAreaImage(EpubViewerDialog dialog) {
        try {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"epubtest03", (String)"resources/ad_banner_1280.jpg");
            Image bgImage = descriptor.createImage();
            dialog.setTitleImage(bgImage);
            dialog.getShell().addListener(12, e -> bgImage.dispose());
        }
        catch (Exception exception) {}
    }

    private void refreshTree(Shell shell) {
        String path = EpubPreferenceManager.getInstance().getPublishFullPath();
        this.getEpubFiles(shell, path);
    }

    private void getEpubFiles(Shell shell, String path) {
        File[] files;
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            this.allEpubFiles = Collections.emptyList();
        }
        this.allEpubFiles = (files = dir.listFiles((d, name) -> name.toLowerCase().endsWith(".epub"))) == null ? Collections.emptyList() : Arrays.stream(files).sorted((f1, f2) -> {
            int cmp = Long.compare(f1.lastModified(), f2.lastModified());
            return this.sortAscending ? cmp : -cmp;
        }).collect(Collectors.toList());
        this.applyFilter(shell);
    }

    @Focus
    public void setFocus() {
    }

    private void applyFilter(Shell shell) {
        for (TableEditor editor : this.editors) {
            if (editor.getEditor() != null && !editor.getEditor().isDisposed()) {
                editor.getEditor().dispose();
            }
            editor.dispose();
        }
        this.editors.clear();
        String keyword = this.searchText.getText().trim().toLowerCase();
        List filtered = this.allEpubFiles.stream().filter(file -> file.getName().toLowerCase().contains(keyword)).collect(Collectors.toList());
        this.tableViewer.getTable().removeAll();
        ArrayList<EpubItem> items = new ArrayList<EpubItem>();
        int i = 0;
        while (i < filtered.size()) {
            File file2 = (File)filtered.get(i);
            long lastModified = file2.lastModified();
            Date date = new Date(lastModified);
            Instant instant = date.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String formattedDate = localDateTime.format(formatter);
            items.add(new EpubItem(i + 1, ((File)filtered.get(i)).getName(), formattedDate, "\uc5f4\uae30", "\uac80\uc99d", file2));
            ++i;
        }
        this.tableViewer.setInput(items);
        Table table = this.tableViewer.getTable();
        TableItem[] itemsArr = table.getItems();
        System.out.println("Table Rows : " + itemsArr.length);
        int i2 = 0;
        while (i2 < itemsArr.length) {
            TableItem item = itemsArr[i2];
            EpubItem epubItem = (EpubItem)item.getData();
            TableEditor openEditor = new TableEditor(table);
            Button openBtn = new Button((Composite)table, 8);
            openBtn.setText("\uc5f4\uae30");
            openBtn.pack();
            openEditor.grabHorizontal = true;
            openEditor.setEditor((Control)openBtn, item, 3);
            this.editors.add(openEditor);
            openBtn.addListener(13, e -> {
                EpubViewerDialog dialog = new EpubViewerDialog(shell, epubItem.getFile());
                Color backgroundColor = new Color((Device)shell.getDisplay(), 220, 235, 250);
                dialog.setTitleAreaColor(backgroundColor.getRGB());
                dialog.open();
            });
            TableEditor checkEditor = new TableEditor(table);
            Button checkBtn = new Button((Composite)table, 8);
            checkBtn.setText("\uac80\uc99d");
            checkBtn.pack();
            checkEditor.grabHorizontal = true;
            checkEditor.setEditor((Control)checkBtn, item, 4);
            this.editors.add(checkEditor);
            checkBtn.addListener(13, e -> Display.getDefault().asyncExec(() -> this.runEpubCheckWithJob(shell, epubItem.getFile())));
            ++i2;
        }
    }

    public void runEpubCheckWithProgress(Shell parentShell, File epubFile) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(parentShell);
        try {
            dialog.run(true, false, monitor -> {
                monitor.beginTask("EPUB \uac80\uc0ac \uc911\uc785\ub2c8\ub2e4...", -1);
                try {
                    String output = this.runEpubCheck(epubFile);
                    Display.getDefault().asyncExec(() -> this.showResultInPart(epubFile.getName(), output));
                }
                catch (Exception e) {
                    Display.getDefault().asyncExec(() -> this.showResultInDialog(parentShell, "\uc624\ub958", e.getMessage()));
                }
                monitor.done();
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
            this.showResultInDialog(parentShell, "\uc624\ub958", e.getMessage());
        }
    }

    private void runEpubCheckWithJob(Shell parentShell, File epubFile) {
        final ProgressMonitorJobsDialog dlg = new ProgressMonitorJobsDialog(parentShell);
        dlg.setCancelable(false);
        dlg.setBlockOnOpen(false);
        EpubCheckJob job = new EpubCheckJob(epubFile, (fileName, output) -> this.showResultInPart(fileName, output));
        job.setUser(true);
        job.setPriority(30);
        job.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, Boolean.TRUE);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(() -> {
                    if (dlg.getShell() != null && !dlg.getShell().isDisposed()) {
                        dlg.close();
                    }
                });
            }
        });
        job.schedule();
        dlg.open();
    }

    public String runEpubCheck(File epubFile) throws IOException, InterruptedException {
        String line;
        String epubcheckDir = EpubBuildUtil.getProjectPath() + "/epubcheck-5.2.1";
        System.out.println("epubcheckDir : " + epubcheckDir);
        String classpath = String.join((CharSequence)File.pathSeparator, epubcheckDir + "/epubcheck.jar", epubcheckDir + "/lib/*");
        ProcessBuilder pb = new ProcessBuilder("java", "-Dfile.encoding=UTF-8", "-cp", classpath, "com.adobe.epubcheck.tool.Checker", epubFile.getAbsolutePath());
        pb.directory(new File(epubcheckDir));
        pb.redirectErrorStream(true);
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("MS949")));
        StringBuilder output = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            output.append(line).append("\n");
        }
        process.waitFor();
        return output.toString();
    }

    private void showResultInDialog(Shell shell, String title, String message) {
        Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)shell, (String)("EPUB \uac80\uc0ac \uacb0\uacfc - " + title), (String)message));
    }

    public void showResultInPart(String title, String message) {
        String targetContributionURI = "EpubCheckResultPart";
        EpubPartManager.getInstance().addPreviewPart(this.application, this.partService, this.modelService, targetContributionURI, title, message);
    }
}

