/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kr.co.goms.epub.managers.EpubPartManager;
import kr.co.goms.epub.managers.ExplorerNodeManager;
import kr.co.goms.epub.menu.ExplorerNode;
import kr.co.goms.epub.smil.SmilNarrationPlayer;
import kr.co.goms.epub.solution.handlers.SaveAsXhtmlFileHandler;
import kr.co.goms.epub.solution.parts.EpubEditorPart;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.providers.ExplorerContentProvider;
import kr.co.goms.epub.solution.providers.ExplorerLabelProvider;
import kr.co.goms.epub.solution.utils.CommonUtil;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import kr.co.goms.epub.solution.utils.ResourceUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.service.event.Event;

public class ProjectExplorerPart {
    private TreeViewer treeViewer;
    private Image folderImage;
    private Image fileImage;
    private String projectName;
    @Inject
    @Optional
    private MApplication application;
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    private IPartListener partListener;
    String editorId = "kr.co.goms.epub.solution.parts.epubeditorpart";
    String partStackId = "kr.co.goms.epub.solution.parts.editpartstack";
    @Inject
    IEventBroker eventBroker;

    @PostConstruct
    public void createComposite(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new TreeViewer(parent, 2818);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new ExplorerContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ExplorerLabelProvider());
        this.treeViewer.addSelectionChangedListener(event -> {
            ExplorerNode node;
            ITreeSelection selection = this.treeViewer.getStructuredSelection();
            Object selected = selection.getFirstElement();
            if (selected instanceof ExplorerNode && (node = (ExplorerNode)selected).isFolder()) {
                this.treeViewer.expandToLevel((Object)node, 1);
            }
        });
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ExplorerNode node;
                Object data;
                if (e.button != 1) {
                    return;
                }
                Tree tree = ProjectExplorerPart.this.treeViewer.getTree();
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null && (data = item.getData()) instanceof ExplorerNode && (node = (ExplorerNode)data).isFolder()) {
                    boolean expanded = ProjectExplorerPart.this.treeViewer.getExpandedState((Object)node);
                    ProjectExplorerPart.this.treeViewer.setExpandedState((Object)node, !expanded);
                }
            }
        });
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        this.projectName = prefs.get("ebook_project_name", "GomsBook");
        String projectPath = prefs.get("ebook_project_folder", "C:\\1004.GomsBook\\01.EPub");
        System.out.println("\ud83d\udcc4 ProjectExplorerPart > projectName : " + this.projectName);
        System.out.println("\ud83d\udcc4 ProjectExplorerPart > projectPath : " + projectPath);
        EpubBuildUtil epubBuildUtil = new EpubBuildUtil();
        epubBuildUtil.createProjectFolder(projectPath, this.projectName);
        this.initMenuData(null);
        Composite tabButtons = new Composite(parent, 0);
        tabButtons.setLayoutData((Object)new GridData(4, 1024, true, false));
        tabButtons.setLayout((Layout)new GridLayout(2, true));
        Button refreshButton = new Button(tabButtons, 8);
        refreshButton.setText("\ud83d\udd04 Reload");
        refreshButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        refreshButton.addListener(13, e -> this.makeTreeData(this.projectName, true));
    }

    public void initMenuData(@Nullable ExplorerNode parent) {
        System.out.println("initMenuData()");
        this.createContextMenu(this.treeViewer);
        this.makeTreeData(this.projectName, false);
        if (parent != null) {
            System.out.println("initMenuData() parent.name : " + parent.name);
            this.treeViewer.refresh((Object)parent, true);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)parent), true);
            this.treeViewer.expandToLevel((Object)parent, 1);
        }
    }

    private void makeTreeData(String projectName, boolean isRefresh) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        List<ExplorerNode> nodeList = ExplorerNodeManager.getInstance().createProjectNodeData(projectName);
        this.sortExplorerNodeTree(nodeList);
        this.treeViewer.setComparator(null);
        List<ExplorerNode> input = nodeList;
        ExplorerNode gomsBook = this.findNodeByName(nodeList, projectName);
        if (gomsBook != null && gomsBook.isFolder()) {
            input = gomsBook.getChildren() != null ? gomsBook.getChildren() : List.of();
        }
        this.treeViewer.setInput(input);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof ExplorerNode) {
                    ExplorerNode node = (ExplorerNode)element;
                    if (!ProjectExplorerPart.this.isRestrictedExtension(node)) {
                        ProjectExplorerPart.this.handleDoubleClick(node);
                    } else {
                        System.out.println("\u274c \ub354\ube14\ud074\ub9ad \uc81c\ud55c\ub41c \ud30c\uc77c\uc785\ub2c8\ub2e4: " + node.name);
                    }
                }
            }
        });
        if (isRefresh) {
            this.treeViewer.refresh();
        }
    }

    public void sortExplorerNodeTree(List<ExplorerNode> nodes) {
        nodes.sort(this.getExplorerNodeComparator());
        for (ExplorerNode node : nodes) {
            if (node.children == null || node.children.isEmpty()) continue;
            this.sortExplorerNodeTree(node.children);
        }
    }

    private Comparator<ExplorerNode> getExplorerNodeComparator() {
        return Comparator.comparingInt(node -> {
            String name = node.name.toLowerCase();
            if (name.equals("cover.xhtml")) {
                return 1;
            }
            if (name.equals("nav.xhtml")) {
                return 2;
            }
            if (name.equals("loi.xhtml")) {
                return 3;
            }
            if (name.equals("lot.xhtml")) {
                return 4;
            }
            if (name.equals("author.xhtml")) {
                return 5;
            }
            if (name.startsWith("chapter")) {
                String numberPart = name.replaceAll("[^0-9]", "");
                try {
                    return 100 + Integer.parseInt(numberPart);
                }
                catch (NumberFormatException numberFormatException) {
                    return 0x7FFFFFFE;
                }
            }
            return Integer.MAX_VALUE;
        });
    }

    private boolean isRestrictedExtension(ExplorerNode node) {
        if (node.isFolder || node.iFile == null) {
            return false;
        }
        String name = node.name.toLowerCase();
        return name.endsWith(".xml") || name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".woff") || name.endsWith(".woff2");
    }

    private boolean isMp3Extension(ExplorerNode node) {
        String name = node.name.toLowerCase();
        return name.endsWith(".mp3");
    }

    private boolean isImgExtension(ExplorerNode node) {
        String name = node.name.toLowerCase();
        return name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif") || name.endsWith(".bmp");
    }

    private void openFileDialog() {
    }

    private void createContextMenu(final TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            ITreeSelection selection = viewer.getStructuredSelection();
            final Object selected = selection.getFirstElement();
            if (selected == null) {
                return;
            }
            final ExplorerNode parentNode = ((ExplorerNode)selected).getParent();
            String parentName = parentNode.name;
            if (selected instanceof ExplorerNode && ((ExplorerNode)selected).isFolder()) {
                final ExplorerNode folderNode = (ExplorerNode)selected;
                manager.add((IAction)new Action("Add File to Folder"){

                    public void run() {
                        ProjectExplorerPart.this.openFileDialogAndCopyTo(folderNode);
                    }
                });
                if ("Text".equals(folderNode.name)) {
                    menuMgr.add((IAction)new Action("New xhtml"){

                        public void run() {
                            boolean confirm;
                            ITreeSelection selection = viewer.getStructuredSelection();
                            Object selectedItem = selection.getFirstElement();
                            if (selectedItem != null && (confirm = MessageDialog.openConfirm((Shell)viewer.getControl().getShell(), (String)"\uc2e0\uaddc \ucd94\uac00 \ud655\uc778", (String)"\ucd94\uac00\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?"))) {
                                ProjectExplorerPart.this.handleAddNewFile(parentNode);
                            }
                        }
                    });
                }
            } else if (selected instanceof ExplorerNode && !((ExplorerNode)selected).isFolder) {
                System.out.println(((ExplorerNode)selected).getIFile().getName());
                System.out.println(((ExplorerNode)selected).getParent().name);
                final ExplorerNode fileNode = (ExplorerNode)selected;
                if ("Text".equals(parentName)) {
                    menuMgr.add((IAction)new Action("New xhtml"){

                        public void run() {
                            boolean confirm;
                            ITreeSelection selection = viewer.getStructuredSelection();
                            Object selectedItem = selection.getFirstElement();
                            if (selectedItem != null && (confirm = MessageDialog.openConfirm((Shell)viewer.getControl().getShell(), (String)"\uc2e0\uaddc \ucd94\uac00 \ud655\uc778", (String)"\ucd94\uac00\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?"))) {
                                ProjectExplorerPart.this.handleAddNewFile(parentNode);
                            }
                        }
                    });
                    menuMgr.add((IAction)new Action("\uc74c\uc131\ubcf4\uae30(Smil)"){

                        public void run() {
                            ITreeSelection selection = viewer.getStructuredSelection();
                            Object selectedItem = selection.getFirstElement();
                            if (selectedItem != null) {
                                EpubPartManager.getInstance().moveSmilPart(ProjectExplorerPart.this.application, ProjectExplorerPart.this.partService, ProjectExplorerPart.this.modelService, (ExplorerNode)selectedItem);
                            }
                        }
                    });
                    if (!fileNode.isFolder() && fileNode.name.contains(".xhtml")) {
                        menuMgr.add((IAction)new Action("\ub2e4\ub978\uc774\ub984\uc73c\ub85c \uc800\uc7a5"){

                            public void run() {
                                System.out.println("\ub2e4\ub978\uc774\ub984\uc73c\ub85c \uc800\uc7a5 > \uc5ec\uae30");
                                SaveAsXhtmlFileHandler handler = new SaveAsXhtmlFileHandler();
                                try {
                                    handler.run(viewer.getControl().getShell(), (IStructuredSelection)viewer.getSelection(), ProjectExplorerPart.this.eventBroker, fileNode);
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                } else if ("Smil".equals(parentName)) {
                    menuMgr.add((IAction)new Action("\uc74c\uc131 Player"){

                        public void run() {
                            ITreeSelection selection = viewer.getStructuredSelection();
                            Object selectedItem = selection.getFirstElement();
                            if (selectedItem != null) {
                                SmilNarrationPlayer smilNarrationPlayer = new SmilNarrationPlayer();
                                IFile smilIFile = ((ExplorerNode)selectedItem).iFile;
                                String filePath = smilIFile.getLocation().toOSString();
                                File smilFile = new File(filePath);
                                try {
                                    smilNarrationPlayer.loadSmil(smilFile);
                                    smilNarrationPlayer.playNarration(smilNarrationPlayer.getItems());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    System.out.println("smil narration error");
                                }
                            }
                        }
                    });
                }
                if (!"content.opf".equals(((ExplorerNode)selected).name)) {
                    if (CommonUtil.isImageFile(((ExplorerNode)selected).name.toString())) {
                        menuMgr.add((IAction)new Action("\ud83c\udf00\uc774\ubbf8\uc9c0 \ud68c\uc804"){

                            public void run() {
                                ITreeSelection selection = viewer.getStructuredSelection();
                                if (selection.isEmpty()) {
                                    return;
                                }
                                ProjectExplorerPart.this.rotatePreviewImage((ExplorerNode)selected);
                                ProjectExplorerPart.this.openPreviewPartFromImage((ExplorerNode)selected);
                            }
                        });
                    }
                    menuMgr.add((IAction)new Action("\uc0ad\uc81c"){

                        public void run() {
                            ITreeSelection selection = viewer.getStructuredSelection();
                            if (selection.isEmpty()) {
                                return;
                            }
                            int size = selection.size();
                            String message = size == 1 ? "\uc815\ub9d0 \uc0ad\uc81c\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?" : String.format("%d\uac1c\uc758 \ud56d\ubaa9\uc744 \uc0ad\uc81c\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?", size);
                            boolean confirm = MessageDialog.openConfirm((Shell)viewer.getControl().getShell(), (String)"\uc0ad\uc81c \ud655\uc778", (String)message);
                            if (confirm) {
                                Object firstItem = selection.getFirstElement();
                                for (Object selectedItem : selection.toList()) {
                                    if (!(selectedItem instanceof ExplorerNode)) continue;
                                    ProjectExplorerPart.this.handleDeleteFile((ExplorerNode)selectedItem);
                                }
                                ProjectExplorerPart.this.refreshMenu((ExplorerNode)firstItem);
                            }
                        }
                    });
                }
            }
        });
    }

    public void rotatePreviewImage(ExplorerNode node) {
        IFile file = node.getIFile();
        String filePath = null;
        if (file != null && file.exists()) {
            filePath = file.getLocation().toOSString();
        }
        File realFile = new File(filePath);
        try {
            ResourceUtil.rotateImageFile(realFile, 90);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void openFileDialogAndCopyTo(ExplorerNode folderNode) {
        System.out.println("openFileDialogAndCopyTo() : " + folderNode.name);
        FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        dialog.setText("Select File to Add");
        String selectedPath = dialog.open();
        if (selectedPath == null) {
            return;
        }
        File sourceFile = new File(selectedPath);
        if (!sourceFile.exists()) {
            return;
        }
        IContainer container = folderNode.getContainer();
        IFile destFile = container.getFile((IPath)new Path(sourceFile.getName()));
        try {
            if (destFile.exists()) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"File Exists", (String)("\ud30c\uc77c\uc774 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4: " + destFile.getName()));
                return;
            }
            Throwable throwable = null;
            Object var8_10 = null;
            try (FileInputStream fis = new FileInputStream(sourceFile);){
                destFile.create((InputStream)fis, true, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String href = container.getProjectRelativePath().append(destFile.getName()).toString().substring("OEBPS/".length());
            String id = destFile.getName().replaceAll("[^a-zA-Z0-9\uac00-\ud7a3]", "_");
            boolean isXhtml = destFile.getName().toLowerCase().endsWith(".xhtml");
            destFile.getName().toLowerCase().endsWith(".css");
            destFile.getName().toLowerCase().endsWith(".jpg");
            boolean addToScripted = isXhtml;
            boolean addToLinearNo = false;
            OpfNcxUpdater.addFileToOpf(container.getProject().getFile("OEBPS/content.opf"), id, href, OpfNcxUpdater.getMediaType(destFile.getName()), isXhtml, addToScripted, addToLinearNo);
            ExplorerNode newNode = new ExplorerNode(destFile.getName(), destFile);
            folderNode.addChild(newNode);
            this.treeViewer.refresh();
        }
        catch (IOException | CoreException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("\ud30c\uc77c \ubcf5\uc0ac \uc2e4\ud328: " + e.toString()));
        }
    }

    private void openFileDialogAndAdd(ExplorerNode folderNode) {
        Shell shell = Display.getDefault().getActiveShell();
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setText("Select File to Add");
        String selectedPath = dialog.open();
        if (selectedPath == null) {
            return;
        }
        try {
            File sourceFile = new File(selectedPath);
            String fileName = sourceFile.getName();
            String projectName = EpubPreferenceManager.getInstance().getProjectName();
            IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder(folderNode.name);
            IFile destFile = iFolder.getFile(fileName);
            Throwable throwable = null;
            Object var11_13 = null;
            try (FileInputStream input = new FileInputStream(sourceFile);){
                if (destFile.exists()) {
                    destFile.delete(true, null);
                }
                destFile.create((InputStream)input, true, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String href = iFolder.getProjectRelativePath().append(fileName).toString().substring("OEBPS/".length());
            String id = fileName.replaceAll("[^a-zA-Z0-9]", "_");
            boolean isXhtml = fileName.toLowerCase().endsWith(".xhtml");
            boolean addToScripted = true;
            boolean addToLinearNo = false;
            OpfNcxUpdater.addFileToOpf(iFolder.getProject().getFile("OEBPS/content.opf"), id, href, OpfNcxUpdater.getMediaType(fileName), isXhtml, addToScripted, addToLinearNo);
            folderNode.addChild(new ExplorerNode(fileName, destFile));
            this.treeViewer.refresh();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void handleDoubleClick(ExplorerNode node) {
        if (node.isFolder()) {
            System.out.println("\ud3f4\ub354 \ub354\ube14 \ud074\ub9ad: " + node.name);
        } else {
            System.out.println("\uc544\uc774\ud15c \ub354\ube14 \ud074\ub9ad: " + node.name);
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
            String projectFolder = prefs.get("ebook_project_folder", "");
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(EpubBuildUtil.getProjectName());
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            IFile file = node.getIFile();
            System.out.println("\ud83d\udcc4 IFile \uc874\uc7ac \uc5ec\ubd80: " + (file != null));
            System.out.println("\ud83d\udcc4 \uc6cc\ud06c\uc2a4\ud398\uc774\uc2a4 \uae30\uc900 exists(): " + file.exists());
            System.out.println("\ud83d\udcc4 IFile.getFullPath(): " + String.valueOf(file.getFullPath()));
            System.out.println("\ud83d\udcc4 \uc2e4\uc81c \ud30c\uc77c \uc2dc\uc2a4\ud15c \uacbd\ub85c: " + String.valueOf(file.getLocation()));
            System.out.println("\ud83d\udcc4 \uc2e4\uc81c \ud30c\uc77c \uc2dc\uc2a4\ud15c \uacbd\ub85cgetRawLocation: " + String.valueOf(file.getRawLocation()));
            System.out.println("\uc544\uc774\ud15c Name : " + file.getName());
            System.out.println("projectFolder : " + projectFolder);
            System.out.println("\uc544\uc774\ud15c filePath#1 : " + String.valueOf(file.getFullPath()));
            if (file != null && file.exists()) {
                String filePath = file.getLocation().toOSString();
                System.out.println("\uc544\uc774\ud15c filePath#2 : " + filePath);
                if (this.isMp3Extension(node)) {
                    this.openEditorSmilPart(node);
                } else if (this.isImgExtension(node)) {
                    this.openPreviewPartFromImage(node);
                } else {
                    this.openEditorE4(this.editorId, filePath);
                }
            } else {
                System.out.println("\uc544\uc774\ud15c filePath : \ud30c\uc77c\uc5c6\uc74c");
            }
        }
    }

    private void openPreviewPartFromImage(ExplorerNode selectedItem) {
        EpubPartManager.getInstance().movePreviewPart(this.application, this.partService, this.modelService, selectedItem);
    }

    private void openEditorSmilPart(ExplorerNode selectedItem) {
        String chapterFileName = CommonUtil.extractChapterIdFromMp3Name(selectedItem.name);
        ExplorerNode chapterNode = new ExplorerNode();
        chapterNode.name = chapterFileName + ".xhtml";
        EpubPartManager.getInstance().moveSmilPart(this.application, this.partService, this.modelService, chapterNode);
    }

    private void openEditorE4(String editorId, String filePath) {
        System.out.println("filePath editorId : kr.co.goms.epub.solution.parts.epubeditorpart");
        System.out.println("partService : " + String.valueOf(this.partService));
        System.out.println("editorId : " + editorId);
        System.out.println("filePath : " + filePath);
        IFile iFile = null;
        for (MPart part : this.partService.getParts()) {
            if (!editorId.equals(part.getElementId())) continue;
            System.out.println("\uc5ec\uae30\ub97c \ud0c0\ub294\uac00\uc694#1");
            String openedPath = (String)part.getPersistedState().get("filePath");
            if (filePath.equals(openedPath)) {
                System.out.println("\uc5ec\uae30\ub97c \ud0c0\ub294\uac00\uc694#2");
                System.out.println("\uc5ec\uae30\ub97c \ud0c0\ub294\uac00\uc694#4");
                if (!part.isToBeRendered() || !part.isVisible()) {
                    this.ensureRenderedAndShown(part, this.partStackId);
                } else {
                    this.partService.showPart(part, EPartService.PartState.ACTIVATE);
                }
                Object obj = part.getObject();
                if (obj instanceof EpubEditorPart) {
                    EpubEditorPart editor = (EpubEditorPart)obj;
                    editor.onFocus();
                    editor.setFilePath(filePath);
                }
                if (openedPath != null) {
                    Path path = new Path(openedPath);
                    iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                    if (iFile == null || !iFile.exists()) {
                        iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    }
                }
                String absPath = iFile != null && iFile.getLocation() != null ? iFile.getLocation().toOSString() : filePath;
                this.eventBroker.post("gomsbook/preview/refresh", Map.of("file", iFile, "path", absPath));
                return;
            }
            System.out.println("\uc5ec\uae30\ub97c \ud0c0\ub294\uac00\uc694#10");
        }
        System.out.println("\ub2e4\uc2dc \uc5f0\uacb0\ud558\uae30\uc785\ub2c8\ub2e4.");
        MPart editorPart = this.partService.createPart(editorId);
        editorPart.setElementId(editorId);
        editorPart.setContributionURI("bundleclass://epubtest03/kr.co.goms.epub.solution.parts.EpubEditorPart");
        editorPart.getPersistedState().put("filePath", filePath);
        editorPart.getPersistedState().put("persistState", "true");
        editorPart.getTags().add("Editor");
        MPartStack partStack = (MPartStack)this.modelService.find(this.partStackId, (MUIElement)this.application);
        if (partStack != null) {
            partStack.getChildren().add(editorPart);
            this.partService.showPart(editorPart, EPartService.PartState.ACTIVATE);
        } else {
            System.out.println("PartStack with ID " + this.partStackId + " not found.");
        }
        EpubEditorPart editor = (EpubEditorPart)editorPart.getObject();
        if (editor != null) {
            editor.setFilePath(filePath);
        }
        Path path = new Path(filePath);
        iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        this.eventBroker.post("gomsbook/preview/refresh", Map.of("file", iFile, "path", filePath));
        final MPartStack targetStack = (MPartStack)this.modelService.find(this.partStackId, (MUIElement)this.application);
        if (targetStack == null) {
            return;
        }
        if (Boolean.TRUE.equals(targetStack.getTransientData().get("preview.listener.bound"))) {
            return;
        }
        this.partService.addPartListener(new IPartListener(){
            private MPart lastActivatedInTarget;

            public void partActivated(MPart part) {
                Object object;
                MElementContainer container = part.getParent();
                if (container != targetStack) {
                    return;
                }
                if (targetStack.getSelectedElement() != part) {
                    return;
                }
                if (part == this.lastActivatedInTarget) {
                    return;
                }
                this.lastActivatedInTarget = part;
                Object fileRef = part.getTransientData().get("currentFile");
                if (fileRef == null && (object = part.getObject()) instanceof EpubEditorPart) {
                    EpubEditorPart ep = (EpubEditorPart)object;
                    fileRef = ep.getFile();
                }
                if (fileRef == null) {
                    return;
                }
                IFile iFileTmp = null;
                String pathStr = null;
                if (fileRef instanceof IFile) {
                    IFile f;
                    iFileTmp = f = (IFile)fileRef;
                    pathStr = f.getLocation() != null ? f.getLocation().toOSString() : f.getFullPath().toString();
                } else if (fileRef instanceof String) {
                    String s;
                    pathStr = s = (String)fileRef;
                    Path p = new Path(s);
                    iFileTmp = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)p);
                } else {
                    return;
                }
                System.out.println("[PREVIEW_REFRESH] file=" + (iFileTmp != null ? iFileTmp.getName() : "null") + " path=" + pathStr);
                ProjectExplorerPart.this.eventBroker.post("gomsbook/preview/refresh", Map.of("file", iFileTmp, "path", pathStr));
            }

            public void partBroughtToTop(MPart part) {
            }

            public void partDeactivated(MPart part) {
            }

            public void partHidden(MPart part) {
            }

            public void partVisible(MPart part) {
            }
        });
        targetStack.getTransientData().put("preview.listener.bound", Boolean.TRUE);
    }

    private static IFile toIFile(String absOrWsPath) {
        if (absOrWsPath == null || absOrWsPath.isEmpty()) {
            return null;
        }
        Path path = new Path(absOrWsPath);
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (iFile != null && iFile.exists()) {
            return iFile;
        }
        iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (iFile != null && iFile.exists()) {
            return iFile;
        }
        return null;
    }

    @Focus
    public void setFocus() {
    }

    @Persist
    public void save() {
    }

    private List<ExplorerNode> createSampleData(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            System.err.println("\u26a0\ufe0f \ud504\ub85c\uc81d\ud2b8 \ub9ac\uc18c\uc2a4 \uc0c8\ub85c\uace0\uce68 \uc2e4\ud328: " + e.getMessage());
        }
        IFolder metaInfFolder = project.getFolder("META-INF");
        ExplorerNode metaInf = new ExplorerNode("META-INF", new ArrayList<ExplorerNode>(), (IContainer)metaInfFolder);
        metaInf.addChild(new ExplorerNode("container.xml", metaInfFolder.getFile("container.xml")));
        IFolder fontsFolder = project.getFolder("OEBPS/Fonts");
        ExplorerNode fonts = new ExplorerNode("Fonts", new ArrayList<ExplorerNode>(), (IContainer)fontsFolder);
        fonts.addChild(new ExplorerNode("spoqahansansneobold.otf", fontsFolder.getFile("spoqahansansneobold.otf")));
        fonts.addChild(new ExplorerNode("spoqahansansneolight.otf", fontsFolder.getFile("spoqahansansneolight.otf")));
        fonts.addChild(new ExplorerNode("spoqahansansneomedium.otf", fontsFolder.getFile("spoqahansansneomedium.otf")));
        fonts.addChild(new ExplorerNode("spoqahansansneoregular.otf", fontsFolder.getFile("spoqahansansneoregular.otf")));
        fonts.addChild(new ExplorerNode("spoqahansansneothin.otf", fontsFolder.getFile("spoqahansansneothin.otf")));
        IFolder imagesFolder = project.getFolder("OEBPS/Images");
        ExplorerNode images = new ExplorerNode("Images", new ArrayList<ExplorerNode>(), (IContainer)imagesFolder);
        images.addChild(new ExplorerNode("cover.jpg", imagesFolder.getFile("cover.jpg")));
        images.addChild(new ExplorerNode("chapter1.jpg", imagesFolder.getFile("chapter1.jpg")));
        images.addChild(new ExplorerNode("chapter2.jpg", imagesFolder.getFile("chapter2.jpg")));
        IFolder stylesFolder = project.getFolder("OEBPS/Styles");
        ExplorerNode styles = new ExplorerNode("Styles", new ArrayList<ExplorerNode>(), (IContainer)stylesFolder);
        styles.addChild(new ExplorerNode("sgc-nav.css", stylesFolder.getFile("sgc-nav.css")));
        styles.addChild(new ExplorerNode("Style0001.css", stylesFolder.getFile("Style0001.css")));
        IFolder textFolder = project.getFolder("OEBPS/Text");
        ExplorerNode text = new ExplorerNode("Text", new ArrayList<ExplorerNode>(), (IContainer)textFolder);
        text.addChild(new ExplorerNode("cover.xhtml", textFolder.getFile("cover.xhtml")));
        text.addChild(new ExplorerNode("index.xhtml", textFolder.getFile("index.xhtml")));
        text.addChild(new ExplorerNode("nav.xhtml", textFolder.getFile("nav.xhtml")));
        text.addChild(new ExplorerNode("chapter1.xhtml", textFolder.getFile("chapter1.xhtml")));
        text.addChild(new ExplorerNode("chapter2.xhtml", textFolder.getFile("chapter2.xhtml")));
        IFolder oebpsFolder = project.getFolder("OEBPS");
        ExplorerNode oebps = new ExplorerNode("OEBPS", new ArrayList<ExplorerNode>(), (IContainer)oebpsFolder);
        oebps.addChild(fonts);
        oebps.addChild(images);
        oebps.addChild(styles);
        oebps.addChild(text);
        oebps.addChild(new ExplorerNode("content.opf", oebpsFolder.getFile("content.opf")));
        return Arrays.asList(metaInf, oebps);
    }

    private void addIfExists(ExplorerNode parent, String filename, IContainer folder) {
        IFile file = folder.getFile((IPath)new Path(filename));
        if (file.exists()) {
            parent.addChild(new ExplorerNode(filename, file));
        } else {
            System.out.println("\u26a0\ufe0f \ud30c\uc77c \uc5c6\uc74c (\uc2a4\ud0b5): " + String.valueOf(file.getFullPath()));
        }
    }

    private void deleteFileNode(ExplorerNode deleteNode) {
        try {
            IFile file = deleteNode.getIFile();
            if (file.exists()) {
                file.delete(true, null);
            }
            String href = file.getProjectRelativePath().toString().replace("OEBPS/", "");
            String id = file.getName().replaceAll("[^a-zA-Z0-9]", "_");
            IFile opf = file.getProject().getFile("OEBPS/content.opf");
            OpfNcxUpdater.removeFileFromOpf(opf, id, href);
            ExplorerNode parent = deleteNode.getParent();
            if (parent != null) {
                parent.getChildren().remove(deleteNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refreshMenu(ExplorerNode explorerNode) {
        ExplorerNode parent = explorerNode.getParent();
        this.initMenuData(parent);
    }

    private void handleAddNewFile(ExplorerNode parent) {
        System.out.println("handleAddNewFile() \uc2dc\uc791\ud558\uae30");
        File textFolder = new File(EpubBuildUtil.getProjectOEBPSSubFolder("Text"));
        System.out.println("handleAddNewFile() textFolder.toPath() : " + String.valueOf(textFolder.toPath()));
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        System.out.println("handleAddNewFile() projectName: " + projectName);
        if (textFolder.exists()) {
            String targetXhtmlFileName = EpubBuildUtil.createNextChapterFile(textFolder);
            ExplorerNode targetExplorerNode = ExplorerNodeManager.getInstance().getNode(targetXhtmlFileName);
            this.initMenuData(targetExplorerNode);
        }
    }

    private void handleDeleteFile(ExplorerNode deleteFileNode) {
        this.deleteFileNode(deleteFileNode);
    }

    public void refreshSmilFolder(String targetSmil) {
        System.out.println("refreshSmilFolder() \ud638\ucd9c");
        if (this.treeViewer == null || this.treeViewer.getTree().isDisposed()) {
            return;
        }
        this.initMenuData(null);
        Object root = this.treeViewer.getInput();
        ExplorerNode smilNode = this.findNodeByName(root, "Smil");
        if (smilNode != null) {
            this.initMenuData(smilNode);
        }
    }

    private ExplorerNode findNodeByName(Object parent, String name) {
        block5: {
            block4: {
                if (!(parent instanceof List)) break block4;
                List list = (List)parent;
                for (Object item : list) {
                    ExplorerNode result = this.findNodeByName(item, name);
                    if (result == null) continue;
                    return result;
                }
                break block5;
            }
            if (!(parent instanceof ExplorerNode)) break block5;
            ExplorerNode node = (ExplorerNode)parent;
            if (name.equalsIgnoreCase(node.name)) {
                return node;
            }
            List<ExplorerNode> children = node.getChildren();
            if (children != null) {
                for (ExplorerNode child : children) {
                    ExplorerNode result = this.findNodeByName(child, name);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    @Inject
    @Optional
    public void subscribe(@UIEventTopic(value="project_explorer/refresh") Event event) {
        System.out.println("subscribe() \uc5ec\uae30\ub85c \uc624\ub098\uc694?????");
        String targetSmil = (String)event.getProperty("org.eclipse.e4.data");
        System.out.println("\ubc1b\uc740 SMIL: " + targetSmil);
        MessageDialog.openInformation((Shell)this.treeViewer.getControl().getShell(), (String)"Smil\uc0dd\uc131 \uc644\ub8cc", (String)"\u2705 Smil\ud3f4\ub354 Reload \ud6c4 \ud655\uc778\ubd80\ud0c1\ub4dc\ub9bd\ub2c8\ub2e4.");
        this.refreshSmilFolder(targetSmil);
    }

    public void resetProjectName() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        this.projectName = prefs.get("ebook_project_name", "GomsBook");
        String projectPath = prefs.get("ebook_project_folder", "C:\\1004.GomsBook\\01.EPub");
        System.out.println("\ud83d\udcc4 ProjectExplorerPart > projectName : " + this.projectName);
        System.out.println("\ud83d\udcc4 ProjectExplorerPart > projectPath : " + projectPath);
        EpubBuildUtil epubBuildUtil = new EpubBuildUtil();
        epubBuildUtil.createProjectFolder(projectPath, this.projectName);
        this.refreshProjectExplorer(null);
    }

    public void refreshProjectExplorer(ExplorerNode explorerNode) {
        this.initMenuData(explorerNode);
    }

    @Inject
    @Optional
    public void onMenuRefresh(@UIEventTopic(value="gomsbook/menu/refresh") Map<String, Object> data) {
        System.out.println("MENU_REFRESH \ubc1b\ub294 \ubd80\ubd84 \uc2dc\uc791\uc785\ub2c8\ub2e4.");
        ExplorerNode node = (ExplorerNode)data.get("node");
        System.out.println("folder : " + node.getIFile().getName());
        this.refreshProjectExplorer(node);
    }

    private void ensureRenderedAndShown(MPart part, String partStackId) {
        part.setToBeRendered(true);
        part.setVisible(true);
        MPartStack stack = (MPartStack)this.modelService.find(partStackId, (MUIElement)this.application);
        if (stack != null && part.getParent() == null) {
            stack.getChildren().add(part);
        }
        this.partService.showPart(part, EPartService.PartState.ACTIVATE);
    }
}

