/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.preferences;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class ColorPreference {
    private static final String RECENT_COLORS = "recentColors";
    private static Preferences prefs;

    public static void saveColor(float[] hsv) {
        prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        String prev = prefs.get(RECENT_COLORS, "");
        String newColor = hsv[0] + "," + hsv[1] + "," + hsv[2];
        LinkedList<String> list = new LinkedList<String>(List.of(prev.split(";")));
        list.remove(newColor);
        list.add(0, newColor);
        while (list.size() > 5) {
            list.remove(list.size() - 1);
        }
        prefs.put(RECENT_COLORS, String.join((CharSequence)";", list));
    }

    public static List<float[]> getRecentColors() {
        prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        String str = prefs.get(RECENT_COLORS, "");
        if (str == null || str.isBlank()) {
            return List.of();
        }
        return Arrays.stream(str.split(";")).map(s -> {
            String[] parts = s.split(",");
            return new float[]{Float.parseFloat(parts[0]), Float.parseFloat(parts[1]), Float.parseFloat(parts[2])};
        }).collect(Collectors.toList());
    }
}

