/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.preferences;

import java.io.File;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class EpubPreferenceManager {
    private static EpubPreferenceManager instance;
    private final Preferences preferences = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
    private static final String NODE = "kr.co.goms.epub.solution";

    private EpubPreferenceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EpubPreferenceManager getInstance() {
        if (instance != null) return instance;
        Class<EpubPreferenceManager> clazz = EpubPreferenceManager.class;
        synchronized (EpubPreferenceManager.class) {
            if (instance != null) return instance;
            instance = new EpubPreferenceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static Preferences prefs() {
        return InstanceScope.INSTANCE.getNode(NODE);
    }

    public void put(String key, String value) {
        this.preferences.put(key, value);
        EpubPreferenceManager.flush();
    }

    public String get(String key, String def) {
        return this.preferences.get(key, def);
    }

    public void putBoolean(String key, boolean value) {
        this.preferences.putBoolean(key, value);
        EpubPreferenceManager.flush();
    }

    public boolean getBoolean(String key, boolean def) {
        return this.preferences.getBoolean(key, def);
    }

    public void remove(String key) {
        this.preferences.remove(key);
        EpubPreferenceManager.flush();
    }

    public static void flush() {
        try {
            EpubPreferenceManager.prefs().flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public String getPublishPath() {
        return this.get("ebook_publish_folder", "C:\\1004.GomsBook\\02.Publish");
    }

    public String getProjectPath() {
        return this.get("ebook_project_folder", "C:\\1004.GomsBook\\01.EPub");
    }

    public String getProjectName() {
        return this.get("ebook_project_name", "GomsBook");
    }

    public String getProjectAuthor() {
        return this.get("ebook_project_author", "\ud55c\uc815\ud6c8");
    }

    public String getProjectFullPath() {
        return this.getProjectPath() + "/" + this.getProjectName();
    }

    public String getPublishFullPath() {
        return this.getPublishPath() + "/" + this.getProjectName();
    }

    public String getProjectBookTitle() {
        return this.get("ebook_project_book_title", "");
    }

    public String getProjectPublishingHouseName() {
        return this.get("ebook_project_publish_house_name", "\uacf0\uc2a4\ubd81");
    }

    public String getProjectPublisherName() {
        return this.get("ebook_project_publisher_name", "\ud55c\uc815\ud6c8");
    }

    public String getProjectPublishingHouseAddr() {
        return this.get("ebook_project_publish_house_addr", "\uc11c\uc6b8\uc2dc \uac15\uc11c\uad6c \uc6b0\uc7a5\uc0b0\ub85c 92, 103\ub3d9 1002\ud638");
    }

    public String getProjectPublishingHouseTel() {
        return this.get("ebook_project_publish_house_tel", "010-6343-3762");
    }

    public String getProjectPublishingHouseEmail() {
        return this.get("ebook_project_publish_house_email", "omaro7@hanmail.net");
    }

    public String getProjectPublishingISBN() {
        return this.get("ebook_project_publish_isbn", "");
    }

    public String getProjectPublishingDate() {
        return this.get("ebook_project_publish_date", "");
    }

    public File getProjectRoot() {
        String path = this.getProjectPath();
        if (path == null || path.isBlank()) {
            return null;
        }
        return new File(path);
    }
}

