/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.preferences;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class QuizPreference {
    public static final String PLUGIN_ID = "kr.co.goms.epub.solution";
    public static final String NODE = "kr.co.goms.epub.solution/quiz";
    public static final String KEY_NUM_QUESTIONS = "numQuestions";
    public static final String KEY_NUM_CHOICES = "numChoices";
    public static final String KEY_DEFAULT_STYLE = "defaultStyle";
    public static final String KEY_ACCESSIBLE = "accessible";
    public static final String KEY_SHOW_SCORE = "showScore";
    public static final String KEY_REMEMBER_LAST = "rememberLast";
    public static final String KEY_LAST_CONFIG_JSON = "lastConfigJson";
    public static final int DEF_NUM_QUESTIONS = 2;
    public static final int DEF_NUM_CHOICES = 4;
    public static final String DEF_STYLE = "CLASSIC";
    public static final boolean DEF_ACCESSIBLE = true;
    public static final boolean DEF_SHOW_SCORE = false;
    public static final boolean DEF_REMEMBER_LAST = true;

    public static IEclipsePreferences node() {
        return InstanceScope.INSTANCE.getNode(NODE);
    }

    public static int numQuestions() {
        return QuizPreference.node().getInt(KEY_NUM_QUESTIONS, 2);
    }

    public static int numChoices() {
        return QuizPreference.node().getInt(KEY_NUM_CHOICES, 4);
    }

    public static String defaultStyle() {
        return QuizPreference.node().get(KEY_DEFAULT_STYLE, DEF_STYLE);
    }

    public static boolean accessible() {
        return QuizPreference.node().getBoolean(KEY_ACCESSIBLE, true);
    }

    public static boolean showScore() {
        return QuizPreference.node().getBoolean(KEY_SHOW_SCORE, false);
    }

    public static boolean rememberLast() {
        return QuizPreference.node().getBoolean(KEY_REMEMBER_LAST, true);
    }

    public static String lastConfigJson() {
        return QuizPreference.node().get(KEY_LAST_CONFIG_JSON, null);
    }

    public static void saveLastConfigJson(String json) {
        QuizPreference.node().put(KEY_LAST_CONFIG_JSON, json != null ? json : "");
        try {
            QuizPreference.node().flush();
        }
        catch (Exception exception) {}
    }
}

