/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.providers;

import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class EpubListLabelProvider
extends LabelProvider {
    private Image icon;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public EpubListLabelProvider() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getClassLoader().getResource("icons/icon_gomsbook_list_20px.png"));
        if (descriptor != null) {
            this.icon = descriptor.createImage();
        }
    }

    public String getText(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            String name = file.getName();
            String modifiedDate = this.dateFormat.format(file.lastModified());
            return name + " " + modifiedDate;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof File) {
            return this.icon;
        }
        return super.getImage(element);
    }

    public void dispose() {
        if (this.icon != null && !this.icon.isDisposed()) {
            this.icon.dispose();
        }
        super.dispose();
    }
}

