/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.registry;

import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.text.source.SourceViewer;

@Creatable
@Singleton
public class EditorRegistry {
    private final Map<IFile, SourceViewer> map = new ConcurrentHashMap<IFile, SourceViewer>();

    public void register(IFile file, SourceViewer viewer) {
        if (file == null || viewer == null) {
            return;
        }
        this.map.put(file, viewer);
    }

    public SourceViewer get(IFile file) {
        if (file == null) {
            return null;
        }
        return this.map.get(file);
    }

    public void unregister(IFile file) {
        if (file == null) {
            return;
        }
        this.map.remove(file);
    }

    public void register(String filePath, SourceViewer viewer) {
        IFile f = EditorRegistry.resolveIFile(filePath);
        if (f != null) {
            this.register(f, viewer);
        }
    }

    public SourceViewer get(String filePath) {
        IFile f = EditorRegistry.resolveIFile(filePath);
        return f != null ? this.get(f) : null;
    }

    public void unregister(String filePath) {
        IFile f = EditorRegistry.resolveIFile(filePath);
        if (f != null) {
            this.unregister(f);
        }
    }

    public boolean contains(IFile file) {
        return file != null && this.map.containsKey(file);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public static IFile resolveIFile(String filePath) {
        if (filePath == null || filePath.isBlank()) {
            return null;
        }
        Path path = new Path(filePath);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (f != null && f.exists()) {
            return f;
        }
        f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        return f != null && f.exists() ? f : null;
    }

    public IFile findFileByViewer(SourceViewer viewer) {
        if (viewer == null) {
            return null;
        }
        for (Map.Entry<IFile, SourceViewer> e : this.map.entrySet()) {
            if (!Objects.equals(e.getValue(), viewer)) continue;
            return e.getKey();
        }
        return null;
    }
}

