/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.utils;

import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class CommonUtil {
    private static final String UUID_FILE = System.getProperty("user.home") + "/.ges-device-id";
    private static final String SECRET_KEY = "gomsbooksecretkey3762";

    public static void showMessageBox(Shell shell, String message) {
        MessageBox infoBox = new MessageBox(shell, 34);
        infoBox.setMessage(message);
        infoBox.open();
    }

    public static void showMessageBoxAndCallback(Shell shell, String message, MessageCallback messageCallback) {
        MessageBox infoBox = new MessageBox(shell, 34);
        infoBox.setMessage(message);
        int response = infoBox.open();
        if (response == 32) {
            System.out.println("OK \ud074\ub9ad\ub428. \uc791\uc5c5 \uc218\ud589 \uc2dc\uc791.");
            messageCallback.callback();
        } else {
            System.out.println("\uc791\uc5c5\uc774 \ucde8\uc18c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        }
    }

    public static void showMessageDailog(Shell shell, String title, String message) {
        MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
    }

    public static String convertNltoBr(String text) {
        if (!text.isEmpty()) {
            text = text.replaceAll("\\r?\\n", "<br/>");
        }
        return text;
    }

    public static int verifyLicense(String licenseKey, String email, String productId) {
        String decoded;
        String sig;
        int responseCode;
        block9: {
            responseCode = 200;
            try {
                String[] parts = licenseKey.split("-");
                System.out.println("parts.length  : " + parts.length);
                if (parts.length != 2) {
                    responseCode = 301;
                    return responseCode;
                }
                String encoded = parts[0];
                sig = parts[1];
                decoded = new String(Base64.getDecoder().decode(encoded), StandardCharsets.UTF_8);
                String[] decodedParts = decoded.split("\\|");
                System.out.println("decodedParts.length  : " + decodedParts.length);
                if (decodedParts.length != 4) {
                    responseCode = 301;
                    return responseCode;
                }
                String decodedEmail = decodedParts[0];
                String decodedDeviceId = decodedParts[1];
                String decodedProductId = decodedParts[2];
                String expiryDateStr = decodedParts[3];
                String localDeviceId = CommonUtil.getDeviceId();
                System.out.println("decodedEmail : " + decodedEmail);
                System.out.println("decodedDeviceId : " + decodedDeviceId);
                System.out.println("decodedProductId : " + decodedProductId);
                System.out.println("expiryDateStr : " + expiryDateStr);
                System.out.println("localDeviceId : " + localDeviceId);
                if (!decodedEmail.equals(email)) {
                    responseCode = 303;
                    return responseCode;
                }
                if (!localDeviceId.equals(decodedDeviceId)) {
                    responseCode = 304;
                    return responseCode;
                }
                if (!decodedProductId.equals(productId)) {
                    responseCode = 305;
                    return responseCode;
                }
                LocalDate expiryDate = LocalDate.parse(expiryDateStr);
                if (!LocalDate.now().isAfter(expiryDate)) break block9;
                return 302;
            }
            catch (Exception exception) {
                responseCode = 999;
                return responseCode;
            }
        }
        String expectedSig = CommonUtil.generateHmacSignature(decoded);
        if (!expectedSig.equals(sig)) {
            responseCode = 301;
        }
        return responseCode;
    }

    public static int verifyLicenseFromServer(String licenseKey, String email, String device, String productId) {
        System.out.println("licenseKey : " + licenseKey);
        System.out.println("email : " + email);
        System.out.println("device : " + device);
        System.out.println("productId : " + productId);
        int responseCode = 999;
        try {
            String requestBody = String.format("key=%s&email=%s&device=%s&product=%s", URLEncoder.encode(licenseKey, StandardCharsets.UTF_8), URLEncoder.encode(email, StandardCharsets.UTF_8), URLEncoder.encode(device, StandardCharsets.UTF_8), URLEncoder.encode(productId, StandardCharsets.UTF_8));
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://app.goms.co.kr/gomsbook/lic/verify.php")).header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                String body = response.body().trim();
                System.out.println("body : " + body);
                responseCode = "VALID".equalsIgnoreCase(body) ? 200 : ("EXPIRED".equalsIgnoreCase(body) ? 302 : ("DEVICE_MISMATCH".equalsIgnoreCase(body) ? 304 : 301));
            } else {
                responseCode = response.statusCode();
            }
            return responseCode;
        }
        catch (Exception exception) {
            responseCode = 999;
            return responseCode;
        }
    }

    private static String generateHmacSignature(String message) throws Exception {
        Mac hmac = Mac.getInstance("HmacSHA256");
        SecretKeySpec keySpec = new SecretKeySpec(SECRET_KEY.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
        hmac.init(keySpec);
        byte[] hashBytes = hmac.doFinal(message.getBytes(StandardCharsets.UTF_8));
        return CommonUtil.bytesToHex(hashBytes).substring(0, 8).toUpperCase();
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hex.append(String.format("%02x", b));
            ++n2;
        }
        return hex.toString();
    }

    public static String getDeviceId() {
        String mac = CommonUtil.getMacAddress();
        if (mac != null) {
            return mac;
        }
        return CommonUtil.getOrCreateUuid();
    }

    private static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                byte[] mac;
                NetworkInterface ni = interfaces.nextElement();
                if (ni == null || ni.isLoopback() || ni.isVirtual() || !ni.isUp() || (mac = ni.getHardwareAddress()) == null || mac.length == 0) continue;
                StringBuilder sb = new StringBuilder();
                byte[] byArray = mac;
                int n = mac.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    sb.append(String.format("%02X", b));
                    ++n2;
                }
                return sb.toString();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static String getOrCreateUuid() {
        try {
            File file = new File(UUID_FILE);
            if (file.exists()) {
                return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8).trim();
            }
            String uuid = UUID.randomUUID().toString().toUpperCase();
            Files.write(file.toPath(), uuid.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
            return uuid;
        }
        catch (IOException iOException) {
            return "UNKNOWN_DEVICE";
        }
    }

    public static String replaceVariables(String template, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            Object value = entry.getValue();
            if ("\uba85\uc5b8".equals(entry.getKey()) && !((String)value).isEmpty()) {
                value = "\u201c" + entry.getValue() + "\u201d";
            }
            template = template.replace("${" + entry.getKey() + "}", (CharSequence)value);
        }
        return template;
    }

    public static String convertNewlinesToParagraphs(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String[] lines = text.split("\\r?\\n");
        StringBuilder html = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().isEmpty()) {
                html.append("<p>").append(CommonUtil.escapeHtml(line)).append("</p>");
            }
            ++n2;
        }
        return html.toString();
    }

    public static String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    public static String changeStylePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Styles/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String styleFileName = matcher.group(1);
            File styleFile = new File(projectFullPath, "OEBPS/Styles/" + styleFileName);
            String styleUri = styleFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(styleUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    public static String getTodayDate(String pattern) {
        LocalDate today = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return today.format(formatter);
    }

    public static String extractChapterIdFromMp3Name(String mp3Filename) {
        Matcher matcher = Pattern.compile("^(chapter\\d+)_").matcher(mp3Filename);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static boolean isImageFile(String name) {
        String lower = name.toLowerCase();
        return lower.endsWith(".jpg") || lower.endsWith(".jpeg") || lower.endsWith(".png") || lower.endsWith(".gif") || lower.endsWith(".bmp");
    }

    public static interface MessageCallback {
        public void callback();
    }
}

