/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.utils;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import kr.co.goms.epub.solution.utils.JwtUtil;

public class JwtCreator {
    private static final Key key = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);

    public static String createJwtWithUUID(String uuid, Date expirationDate) {
        return Jwts.builder().claim("uuid", (Object)uuid).setExpiration(expirationDate).signWith(key).compact();
    }

    public static void test() {
        String uuid = JwtUtil.getUUID();
        System.out.println("UUID: " + uuid);
        Date expireDate = new Date(System.currentTimeMillis() + 604800000L);
        String jwt = JwtCreator.createJwtWithUUID(uuid, expireDate);
        System.out.println("JWT: " + jwt);
    }
}

