/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class InstallOperation
implements IRunnableWithProgress {
    private String installPath;

    public InstallOperation(String installPath) {
        this.installPath = installPath;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("\ud30c\uc77c \uc124\uce58 \uc911...", -1);
        try {
            try {
                Path target = Paths.get(this.installPath, new String[0]);
                Files.createDirectories(target, new FileAttribute[0]);
                Path sourceDir = Paths.get("resources/install_files", new String[0]);
                Files.walk(sourceDir, new FileVisitOption[0]).forEach(source -> {
                    try {
                        Path dest = target.resolve(sourceDir.relativize((Path)source));
                        if (Files.isDirectory(source, new LinkOption[0])) {
                            Files.createDirectories(dest, new FileAttribute[0]);
                        } else {
                            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("\ud30c\uc77c \ubcf5\uc0ac \uc2e4\ud328: " + e.getMessage(), e);
                    }
                });
            }
            catch (IOException e1) {
                e1.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void log(String message) {
        try {
            Path logFile = Paths.get(this.installPath, "install.log");
            Files.writeString(logFile, (CharSequence)(message + "\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void unzip(Path zipFilePath, Path targetDir) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path outPath = targetDir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(outPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                Files.copy(zis, outPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void logInstall(Path file) {
        try {
            Path logFile = Paths.get(this.installPath, "install.log");
            String type = Files.isDirectory(file, new LinkOption[0]) ? "DIR:" : "FILE:";
            Files.writeString(logFile, (CharSequence)(type + file.toString() + "\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

