/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.wizard;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.util.Date;
import kr.co.goms.epub.solution.utils.JwtUtil;

public class LicenseChecker {
    private static final String LIC_FILE_PATH = "C:/Program Files/Gomsbook/gomsbook.lic";
    private static final Key key = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);

    public static boolean isLicenseValid() {
        Date expiration;
        block3: {
            String jwt = new String(Files.readAllBytes(Paths.get(LIC_FILE_PATH, new String[0])));
            Claims claims = (Claims)Jwts.parserBuilder().build().parseClaimsJws(jwt).getBody();
            expiration = claims.getExpiration();
            if (expiration != null) break block3;
            return false;
        }
        try {
            return expiration.after(new Date());
        }
        catch (JwtException | IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isLicenseValidForThisMachine(String jwt) {
        Claims claims;
        block3: {
            try {
                Jws jwsClaims = Jwts.parserBuilder().setSigningKey(key).build().parseClaimsJws(jwt);
                claims = (Claims)jwsClaims.getBody();
                Date expiration = claims.getExpiration();
                if (expiration != null && !expiration.before(new Date())) break block3;
                return false;
            }
            catch (JwtException e) {
                e.printStackTrace();
                return false;
            }
        }
        String jwtUuid = (String)claims.get("uuid", String.class);
        String systemUuid = JwtUtil.getUUID();
        return systemUuid != null && systemUuid.equalsIgnoreCase(jwtUuid);
    }
}

