/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.wizard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UninstallOperation
implements IRunnableWithProgress {
    private final String installPath;
    private final Shell shell;

    public UninstallOperation(String installPath, Shell shell) {
        this.installPath = installPath;
        this.shell = shell;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("\ud504\ub85c\uadf8\ub7a8 \uc81c\uac70 \uc911...", -1);
        try {
            if (this.isProgramRunning("MyApp.exe")) {
                Display.getDefault().syncExec(() -> MessageDialog.openWarning((Shell)this.shell, (String)"\uacbd\uace0", (String)"\ud504\ub85c\uadf8\ub7a8\uc774 \uc2e4\ud589 \uc911\uc785\ub2c8\ub2e4. \uba3c\uc800 \uc885\ub8cc\ud558\uace0 \uc81c\uac70\ub97c \ub2e4\uc2dc \uc2dc\ub3c4\ud558\uc138\uc694."));
                return;
            }
            AtomicBoolean confirm = new AtomicBoolean(false);
            Display.getDefault().syncExec(() -> {
                boolean result = MessageDialog.openConfirm((Shell)this.shell, (String)"\uc81c\uac70 \ud655\uc778", (String)"\uc815\ub9d0\ub85c \ud504\ub85c\uadf8\ub7a8\uc744 \uc81c\uac70\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?");
                confirm.set(result);
            });
            if (confirm.get()) {
                Path logFile = Paths.get(this.installPath, "install.log");
                if (Files.exists(logFile, new LinkOption[0])) {
                    this.deleteFromLog(logFile);
                    Files.deleteIfExists(logFile);
                } else {
                    this.deleteRecursively(Paths.get(this.installPath, new String[0]));
                }
                this.removeShortcut();
                Display.getDefault().syncExec(() -> MessageDialog.openInformation((Shell)this.shell, (String)"\uc644\ub8cc", (String)"\ud504\ub85c\uadf8\ub7a8\uc774 \uc131\uacf5\uc801\uc73c\ub85c \uc81c\uac70\ub418\uc5c8\uc2b5\ub2c8\ub2e4."));
                monitor.done();
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "\uc81c\uac70 \uc2e4\ud328: " + e.getMessage());
        }
    }

    private boolean isProgramRunning(String processName) {
        try {
            Process process = Runtime.getRuntime().exec("tasklist");
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                return reader.lines().anyMatch(line -> line.contains(processName));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void deleteFromLog(Path logFile) throws IOException {
        List<String> lines = Files.readAllLines(logFile);
        for (String line : lines) {
            if (!line.startsWith("FILE:")) continue;
            Files.deleteIfExists(Paths.get(line.substring(5), new String[0]));
        }
        for (String line : lines) {
            if (!line.startsWith("DIR:")) continue;
            Files.deleteIfExists(Paths.get(line.substring(4), new String[0]));
        }
    }

    private void deleteRecursively(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Stream<Path> entries = Files.list(path);){
                for (Path entry : entries.toList()) {
                    this.deleteRecursively(entry);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        Files.deleteIfExists(path);
    }

    private void removeShortcut() {
        Path shortcut = Paths.get(System.getProperty("user.home"), "Desktop", "MyApp.lnk");
        try {
            Files.deleteIfExists(shortcut);
        }
        catch (IOException iOException) {}
    }
}

