/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.object;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import kr.dogfoot.hwplib.object.Scripts;
import kr.dogfoot.hwplib.object.bindata.BinData;
import kr.dogfoot.hwplib.object.bodytext.BodyText;
import kr.dogfoot.hwplib.object.docinfo.DocInfo;
import kr.dogfoot.hwplib.object.fileheader.FileHeader;
import kr.dogfoot.hwplib.org.apache.poi.hpsf.MarkUnsupportedException;
import kr.dogfoot.hwplib.org.apache.poi.hpsf.NoPropertySetStreamException;
import kr.dogfoot.hwplib.org.apache.poi.hpsf.PropertySet;
import kr.dogfoot.hwplib.org.apache.poi.hpsf.SummaryInformation;
import kr.dogfoot.hwplib.org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import kr.dogfoot.hwplib.org.apache.poi.hpsf.WritingNotSupportedException;

public class HWPFile {
    private FileHeader fileHeader = new FileHeader();
    private DocInfo docInfo = new DocInfo();
    private BodyText bodyText = new BodyText();
    private BinData binData = new BinData();
    private SummaryInformation summaryInformation;
    private Scripts scripts = new Scripts();

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public DocInfo getDocInfo() {
        return this.docInfo;
    }

    public BodyText getBodyText() {
        return this.bodyText;
    }

    public BinData getBinData() {
        return this.binData;
    }

    public SummaryInformation getSummaryInformation() {
        return this.summaryInformation;
    }

    public void setSummaryInformation(SummaryInformation summaryInformation) {
        this.summaryInformation = summaryInformation;
    }

    public Scripts getScripts() {
        return this.scripts;
    }

    public HWPFile clone(boolean deepCopyImage) {
        HWPFile cloned = new HWPFile();
        cloned.copy(this, deepCopyImage);
        return cloned;
    }

    public void copy(HWPFile from, boolean deepCopyImage) {
        this.fileHeader.copy(from.fileHeader);
        this.docInfo.copy(from.docInfo);
        this.bodyText.copy(from.bodyText);
        this.binData.copy(from.binData, deepCopyImage);
        if (from.summaryInformation != null) {
            this.copySummaryInformation(from.summaryInformation);
        }
        this.scripts.copy(from.scripts);
    }

    private void copySummaryInformation(SummaryInformation from) {
        try {
            byte[] source = from.toBytes();
            ByteArrayInputStream bis = new ByteArrayInputStream(source);
            PropertySet propertySet = new PropertySet(bis);
            this.summaryInformation = new SummaryInformation(propertySet);
        }
        catch (WritingNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnexpectedPropertySetTypeException e) {
            throw new RuntimeException(e);
        }
        catch (NoPropertySetStreamException e) {
            throw new RuntimeException(e);
        }
        catch (MarkUnsupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

