/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.object.bodytext.control;

import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.CtrlData;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeader;

public abstract class Control {
    protected CtrlHeader header;
    protected CtrlData ctrlData;

    public Control(CtrlHeader header) {
        this.header = header;
        this.ctrlData = null;
    }

    public ControlType getType() {
        return ControlType.ctrlIdOf(this.header.getCtrlId());
    }

    public boolean isNullHeader() {
        return this.header == null;
    }

    public boolean isField() {
        return ControlType.isField(this.header.getCtrlId());
    }

    public void createCtrlData() {
        this.ctrlData = new CtrlData();
    }

    public void deleteCtrlData() {
        this.ctrlData = null;
    }

    public CtrlData getCtrlData() {
        return this.ctrlData;
    }

    public void setCtrlData(CtrlData ctrlData) {
        this.ctrlData = new CtrlData();
    }

    public abstract Control clone();

    public void copyControlPart(Control from) {
        if (from.header != null) {
            this.header.copy(from.header);
        } else {
            this.header = null;
        }
        if (from.ctrlData != null) {
            this.createCtrlData();
            this.ctrlData.copy(from.ctrlData);
        } else {
            this.ctrlData = null;
        }
    }
}

