/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.object.bodytext.paragraph;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlForm;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.control.FactoryForControl;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderGso;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControlType;
import kr.dogfoot.hwplib.object.bodytext.paragraph.charshape.ParaCharShape;
import kr.dogfoot.hwplib.object.bodytext.paragraph.header.ParaHeader;
import kr.dogfoot.hwplib.object.bodytext.paragraph.lineseg.ParaLineSeg;
import kr.dogfoot.hwplib.object.bodytext.paragraph.rangetag.ParaRangeTag;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.ParaText;

public class Paragraph {
    public static final Paragraph[] Zero_Array = new Paragraph[0];
    private ParaHeader header = new ParaHeader();
    private ParaText text;
    private ParaCharShape charShape;
    private ParaLineSeg lineSeg;
    private ParaRangeTag rangeTag;
    private ArrayList<Control> controlList;

    public ParaHeader getHeader() {
        return this.header;
    }

    public void createText() {
        this.text = new ParaText();
    }

    public void deleteText() {
        this.text = null;
    }

    public ParaText getText() {
        return this.text;
    }

    public void createCharShape() {
        this.charShape = new ParaCharShape();
    }

    public void deleteCharShape() {
        this.charShape = null;
    }

    public ParaCharShape getCharShape() {
        return this.charShape;
    }

    public void createLineSeg() {
        this.lineSeg = new ParaLineSeg();
    }

    public void deleteLineSeg() {
        this.lineSeg = null;
    }

    public ParaLineSeg getLineSeg() {
        return this.lineSeg;
    }

    public void createRangeTag() {
        this.rangeTag = new ParaRangeTag();
    }

    public void deleteRangeTag() {
        this.rangeTag = null;
    }

    public ParaRangeTag getRangeTag() {
        return this.rangeTag;
    }

    public Control addNewControl(ControlType type) {
        return this.addNewControl(type.getCtrlId());
    }

    public Control addNewControl(long id) {
        if (this.controlList == null) {
            this.controlList = new ArrayList();
        }
        Control c = FactoryForControl.create(id);
        this.controlList.add(c);
        return c;
    }

    public GsoControl addNewGsoControl(GsoControlType gsoType) {
        return this.addNewGsoControl(gsoType.getId(), new CtrlHeaderGso());
    }

    public GsoControl addNewGsoControl(GsoControlType gsoType, CtrlHeaderGso header) {
        return this.addNewGsoControl(gsoType.getId(), header);
    }

    public ControlForm addNewFormControl(CtrlHeaderGso header) {
        if (this.controlList == null) {
            this.controlList = new ArrayList();
        }
        ControlForm fc = FactoryForControl.createFormControl(header);
        this.controlList.add(fc);
        return fc;
    }

    public GsoControl addNewGsoControl(long gsoId, CtrlHeaderGso header) {
        if (this.controlList == null) {
            this.controlList = new ArrayList();
        }
        GsoControl gc = FactoryForControl.createGso(gsoId, header);
        this.controlList.add(gc);
        return gc;
    }

    public ArrayList<Control> getControlList() {
        return this.controlList;
    }

    public void createControlList() {
        this.controlList = new ArrayList();
    }

    public int getControlIndex(Control c) {
        return this.controlList.indexOf(c);
    }

    public String getNormalString() throws UnsupportedEncodingException {
        if (this.text != null) {
            return this.text.getNormalString(0);
        }
        return "";
    }

    public Paragraph clone() {
        Paragraph cloned = new Paragraph();
        cloned.header.copy(this.header);
        cloned.text = this.text != null ? this.text.clone() : null;
        cloned.charShape = this.charShape != null ? this.charShape.clone() : null;
        cloned.lineSeg = this.lineSeg != null ? this.lineSeg.clone() : null;
        cloned.rangeTag = this.rangeTag != null ? this.rangeTag.clone() : null;
        if (this.controlList != null) {
            cloned.controlList = new ArrayList();
            for (Control control : this.controlList) {
                cloned.controlList.add(control.clone());
            }
        } else {
            cloned.controlList = null;
        }
        return cloned;
    }
}

