/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.object.bodytext.paragraph.text;

import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlID;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharType;

public class HWPCharControlExtend
extends HWPChar {
    private byte[] addition;

    @Override
    public HWPCharType getType() {
        return HWPCharType.ControlExtend;
    }

    public String getInstanceId() {
        int bufferIndex = 0;
        boolean insert = false;
        byte[] buf = new byte[this.addition.length];
        for (int index = this.addition.length - 1; index >= 0; --index) {
            if (this.addition[index] != 0) {
                insert = true;
            }
            if (!insert) continue;
            buf[bufferIndex++] = this.addition[index];
        }
        return new String(buf, 0, bufferIndex);
    }

    public byte[] getAddition() {
        return this.addition;
    }

    public void setAddition(byte[] addition) throws Exception {
        if (addition.length != 12) {
            throw new Exception("addition's length must be 12");
        }
        this.addition = addition;
    }

    public boolean isSectionDefine() {
        return this.getCode() == 2 && this.hasAddition('s', 'e', 'c', 'd');
    }

    private boolean hasAddition(char byte1, char byte2, char byte3, char byte4) {
        return this.addition != null && this.addition[3] == byte1 && this.addition[2] == byte2 && this.addition[1] == byte3 && this.addition[0] == byte4;
    }

    public boolean isColumnDefine() {
        return this.getCode() == 2 && this.hasAddition('c', 'o', 'l', 'd');
    }

    public boolean isFieldStart() {
        if (this.getCode() == 3 && this.addition != null) {
            long ctrlID = CtrlID.make((char)this.addition[3], (char)this.addition[2], (char)this.addition[1], (char)this.addition[0]);
            return ControlType.isField(ctrlID);
        }
        return false;
    }

    public boolean isHyperlinkStart() {
        return this.getCode() == 3 && this.hasAddition('%', 'h', 'l', 'k');
    }

    public boolean isTable() {
        return this.getCode() == 11 && this.hasAddition('t', 'b', 'l', ' ');
    }

    public boolean isGSO() {
        return this.getCode() == 11 && this.hasAddition('g', 's', 'o', ' ');
    }

    public boolean isEquation() {
        return this.getCode() == 11 && this.hasAddition('e', 'q', 'e', 'd');
    }

    public boolean isForm() {
        return this.getCode() == 11 && this.hasAddition('f', 'o', 'r', 'm');
    }

    public boolean isHiddenComment() {
        return this.getCode() == 15 && this.hasAddition('t', 'c', 'm', 't');
    }

    public boolean isHeader() {
        return this.getCode() == 16 && this.hasAddition('h', 'e', 'a', 'd');
    }

    public boolean isFooter() {
        return this.getCode() == 16 && this.hasAddition('f', 'o', 'o', 't');
    }

    public boolean isFootNote() {
        return this.getCode() == 17 && this.hasAddition('f', 'n', ' ', ' ');
    }

    public boolean isEndNote() {
        return this.getCode() == 17 && this.hasAddition('e', 'n', ' ', ' ');
    }

    public boolean isAutoNumber() {
        return this.getCode() == 18 && this.hasAddition('a', 't', 'n', 'o');
    }

    public boolean isPageHide() {
        return this.getCode() == 21 && this.hasAddition('p', 'g', 'h', 'd');
    }

    public boolean isPageOddEvenAdjust() {
        return this.getCode() == 21 && this.hasAddition('p', 'g', 'c', 't');
    }

    public boolean isPageNumberPosition() {
        return this.getCode() == 21 && this.hasAddition('p', 'g', 'n', 'p');
    }

    public boolean isIndexMark() {
        return this.getCode() == 22 && this.hasAddition('i', 'd', 'x', 'm');
    }

    public boolean isBookmark() {
        return this.getCode() == 22 && this.hasAddition('b', 'o', 'k', 'm');
    }

    public boolean isAdditionalText() {
        return this.getCode() == 23 && this.hasAddition('t', 'd', 'u', 't');
    }

    public boolean isOverlappingLetter() {
        return this.getCode() == 23 && this.hasAddition('t', 'c', 'p', 's');
    }

    @Override
    public HWPChar clone() {
        HWPCharControlExtend cloned = new HWPCharControlExtend();
        cloned.code = this.code;
        cloned.addition = (byte[])(this.addition != null ? (byte[])this.addition.clone() : null);
        return cloned;
    }

    @Override
    public int getCharSize() {
        return 8;
    }
}

