/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import kr.dogfoot.hwplib.object.HWPFile;
import kr.dogfoot.hwplib.object.docinfo.BinData;
import kr.dogfoot.hwplib.object.docinfo.bindata.BinDataCompress;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.org.apache.poi.hpsf.PropertySet;
import kr.dogfoot.hwplib.org.apache.poi.hpsf.SummaryInformation;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentInputStream;
import kr.dogfoot.hwplib.reader.ForFileHeader;
import kr.dogfoot.hwplib.reader.bodytext.ForParagraphList;
import kr.dogfoot.hwplib.reader.bodytext.ForSection;
import kr.dogfoot.hwplib.reader.bodytext.memo.ForMemo;
import kr.dogfoot.hwplib.reader.docinfo.ForDocInfo;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractMethod;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractorListener;
import kr.dogfoot.hwplib.util.compoundFile.reader.CompoundFileReader;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class HWPReader {
    private HWPFile hwpFile;
    private CompoundFileReader cfr;

    public static HWPFile fromFile(String filepath) throws Exception {
        return HWPReader.fromInputStream(new FileInputStream(filepath));
    }

    public static HWPFile fromFile(File file) throws Exception {
        HWPReader r = new HWPReader();
        r.hwpFile = new HWPFile();
        r.cfr = new CompoundFileReader(file);
        r.fileHeader();
        if (r.hasPassword()) {
            throw new Exception("Files with passwords are not supported.");
        }
        r.docInfo();
        r.bodyText();
        r.binData();
        r.summaryInformation();
        r.cfr.close();
        return r.hwpFile;
    }

    public static HWPFile fromURL(String url) throws Exception {
        return HWPReader.fromInputStream(new URL(url).openStream());
    }

    public static HWPFile fromInputStream(InputStream is) throws Exception {
        HWPReader r = new HWPReader();
        r.hwpFile = new HWPFile();
        r.cfr = new CompoundFileReader(is);
        r.fileHeader();
        if (r.hasPassword()) {
            throw new Exception("Files with passwords are not supported.");
        }
        r.docInfo();
        r.bodyText();
        r.binData();
        r.summaryInformation();
        r.scripts();
        r.cfr.close();
        return r.hwpFile;
    }

    public static HWPFile fromBase64String(String base64) throws Exception {
        byte[] binary = DatatypeConverter.parseBase64Binary((String)base64);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(binary);
        return HWPReader.fromInputStream(byteArrayInputStream);
    }

    private HWPReader() {
    }

    private void fileHeader() throws Exception {
        StreamReader sr = this.cfr.getChildStreamReader("FileHeader", false, null);
        ForFileHeader.read(this.hwpFile.getFileHeader(), sr);
        sr.close();
    }

    private boolean hasPassword() {
        return this.hwpFile.getFileHeader().hasPassword();
    }

    private boolean isDistribution() {
        return this.hwpFile.getFileHeader().isDistribution();
    }

    private void docInfo() throws Exception {
        StreamReader sr = this.cfr.getChildStreamReader("DocInfo", this.isCompressed(), this.getVersion());
        new ForDocInfo().read(this.hwpFile.getDocInfo(), sr);
        sr.close();
    }

    private boolean isCompressed() {
        return this.hwpFile.getFileHeader().isCompressed();
    }

    private FileVersion getVersion() {
        return this.hwpFile.getFileHeader().getVersion();
    }

    private void bodyText() throws Exception {
        if (!this.isDistribution()) {
            this.cfr.moveChildStorage("BodyText");
        } else {
            this.cfr.moveChildStorage("ViewText");
        }
        int sectionCount = this.hwpFile.getDocInfo().getDocumentProperties().getSectionCount();
        for (int index = 0; index < sectionCount; ++index) {
            this.section(index);
        }
        this.cfr.moveParentStorage();
    }

    private void section(int index) throws Exception {
        StreamReader sr = this.streamReader("Section" + index);
        sr.setDocInfo(this.hwpFile.getDocInfo());
        ForSection.read(this.hwpFile.getBodyText().addNewSection(), sr);
        if (this.isLastSection(index)) {
            this.memo(sr);
        }
        sr.close();
    }

    private StreamReader streamReader(String name) throws Exception {
        if (!this.isDistribution()) {
            return this.cfr.getChildStreamReader(name, this.isCompressed(), this.getVersion());
        }
        return this.cfr.getChildStreamReaderForDistribution(name, this.isCompressed(), this.getVersion());
    }

    private boolean isLastSection(int index) {
        return index + 1 == this.hwpFile.getDocInfo().getDocumentProperties().getSectionCount();
    }

    private void memo(StreamReader sr) throws Exception {
        while (!sr.isEndOfStream()) {
            if (!sr.isImmediatelyAfterReadingHeader()) {
                sr.readRecordHeader();
            }
            if (sr.getCurrentRecordHeader().getTagID() != 93) continue;
            ForMemo.read(this.hwpFile.getBodyText().addNewMemo(), sr);
        }
    }

    private void binData() throws Exception {
        if (this.cfr.isChildStorage("BinData")) {
            this.cfr.moveChildStorage("BinData");
            Set<String> ss = this.cfr.listChildNames();
            for (String name : ss) {
                int id = this.nameToID(name);
                BinDataCompress compressMethod = this.getCompressMethod(id);
                this.hwpFile.getBinData().addNewEmbeddedBinaryData(name, this.readEmbeddedBinaryData(name, compressMethod), compressMethod);
            }
            this.cfr.moveParentStorage();
        }
    }

    private int nameToID(String name) {
        String id = name.substring(3, 7);
        return Integer.parseInt(id, 16);
    }

    private BinDataCompress getCompressMethod(int id) {
        BinData binData;
        try {
            binData = this.hwpFile.getDocInfo().getBinDataList().get(id - 1);
        }
        catch (Exception e) {
            binData = null;
        }
        if (binData != null) {
            return binData.getProperty().getCompress();
        }
        return BinDataCompress.ByStorageDefault;
    }

    private byte[] readEmbeddedBinaryData(String name, BinDataCompress compressMethod) throws Exception {
        StreamReader sr = this.cfr.getChildStreamReader(name, this.isCompressBinData(compressMethod), null);
        byte[] binaryData = new byte[(int)sr.getSize()];
        sr.readBytes(binaryData);
        sr.close();
        return binaryData;
    }

    private boolean isCompressBinData(BinDataCompress compressMethod) {
        switch (compressMethod) {
            case ByStorageDefault: {
                return this.isCompressed();
            }
            case Compress: {
                return true;
            }
            case NoCompress: {
                return false;
            }
        }
        return false;
    }

    private void summaryInformation() throws Exception {
        DocumentInputStream dis;
        try {
            dis = this.cfr.getChildInputStream("\u0005HwpSummaryInformation");
        }
        catch (FileNotFoundException e) {
            dis = null;
        }
        if (dis != null) {
            PropertySet propertySet = new PropertySet(dis);
            this.hwpFile.setSummaryInformation(new SummaryInformation(propertySet));
            dis.close();
        }
    }

    private void scripts() throws Exception {
        if (this.cfr.isChildStorage("Scripts")) {
            this.cfr.moveChildStorage("Scripts");
            StreamReader sr = this.streamReader("DefaultJScript");
            byte[] data = new byte[(int)sr.getSize()];
            sr.readBytes(data);
            sr.close();
            this.hwpFile.getScripts().setDefaultJScript(data);
            sr = this.streamReader("JScriptVersion");
            data = new byte[(int)sr.getSize()];
            sr.readBytes(data);
            sr.close();
            this.hwpFile.getScripts().setJScriptVersion(data);
            this.cfr.moveParentStorage();
        }
    }

    public static void forExtractText(String filepath, TextExtractorListener listener, TextExtractMethod tem) throws Exception {
        HWPReader.forExtractText(new FileInputStream(filepath), listener, tem);
    }

    private static void forExtractText(FileInputStream is, TextExtractorListener listener, TextExtractMethod tem) throws Exception {
        HWPReader r = new HWPReader();
        r.hwpFile = new HWPFile();
        r.cfr = new CompoundFileReader(is);
        r.fileHeader();
        if (r.hasPassword()) {
            throw new Exception("Files with passwords are not supported.");
        }
        if (r.isDistribution()) {
            throw new Exception("Distribution Files are not supported.");
        }
        r.docInfo();
        r.extractBodyText(listener, tem);
        r.cfr.close();
    }

    private void extractBodyText(TextExtractorListener listener, TextExtractMethod tem) throws Exception {
        this.cfr.moveChildStorage("BodyText");
        int sectionCount = this.hwpFile.getDocInfo().getDocumentProperties().getSectionCount();
        for (int index = 0; index < sectionCount; ++index) {
            this.extractSectionText(index, listener, tem);
        }
        this.cfr.moveParentStorage();
    }

    private void extractSectionText(int sectionIndex, TextExtractorListener listener, TextExtractMethod tem) throws Exception {
        StreamReader sr = this.cfr.getChildStreamReader("Section" + sectionIndex, this.isCompressed(), this.getVersion());
        sr.setDocInfo(this.hwpFile.getDocInfo());
        ForParagraphList.extractText(sr, listener, tem);
        sr.close();
    }
}

