/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.bodytext.paragraph.control;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.ControlSectionDefine;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.bookmark.ForCtrlData;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.secd.ForBatangPageInfo;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.secd.ForCtrlHeaderSecd;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.secd.ForFootEndNoteShape;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.secd.ForPageBorderFill;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.secd.ForPageDef;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForControlSectionDefine {
    private ControlSectionDefine secd;
    private StreamReader sr;
    private short ctrlHeaderLevel;
    private int endFootnoteShapeIndex = 0;
    private int pageBorderFillIndex = 0;

    public void read(ControlSectionDefine secd, StreamReader sr) throws Exception {
        this.secd = secd;
        this.sr = sr;
        this.ctrlHeaderLevel = sr.getCurrentRecordHeader().getLevel();
        this.ctrlHeader();
        while (!sr.isEndOfStream()) {
            if (!sr.isImmediatelyAfterReadingHeader()) {
                sr.readRecordHeader();
            }
            if (this.ctrlHeaderLevel >= sr.getCurrentRecordHeader().getLevel()) break;
            this.readBody();
        }
    }

    private void ctrlHeader() throws IOException {
        ForCtrlHeaderSecd.read(this.secd.getHeader(), this.sr);
    }

    private void readBody() throws Exception {
        switch (this.sr.getCurrentRecordHeader().getTagID()) {
            case 73: {
                this.pageDef();
                break;
            }
            case 74: {
                this.endFootnoteShapes();
                break;
            }
            case 75: {
                this.pageBorderFills();
                break;
            }
            case 72: {
                this.batangPageInfo();
                break;
            }
            case 87: {
                this.ctrlData();
            }
        }
    }

    private void pageDef() throws IOException {
        ForPageDef.read(this.secd.getPageDef(), this.sr);
    }

    private void endFootnoteShapes() throws IOException {
        if (this.endFootnoteShapeIndex == 0) {
            this.footNoteShape();
        } else if (this.endFootnoteShapeIndex == 1) {
            this.endNoteShape();
        }
        ++this.endFootnoteShapeIndex;
    }

    private void footNoteShape() throws IOException {
        ForFootEndNoteShape.read(this.secd.getFootNoteShape(), this.sr);
    }

    private void endNoteShape() throws IOException {
        ForFootEndNoteShape.read(this.secd.getEndNoteShape(), this.sr);
    }

    private void pageBorderFills() throws IOException {
        if (this.pageBorderFillIndex == 0) {
            this.bothPageBorderFill();
        } else if (this.pageBorderFillIndex == 1) {
            this.evenPageBorderFill();
        } else if (this.pageBorderFillIndex == 2) {
            this.oddPageBorderFill();
        }
        ++this.pageBorderFillIndex;
    }

    private void bothPageBorderFill() throws IOException {
        ForPageBorderFill.read(this.secd.getBothPageBorderFill(), this.sr);
    }

    private void evenPageBorderFill() throws IOException {
        ForPageBorderFill.read(this.secd.getEvenPageBorderFill(), this.sr);
    }

    private void oddPageBorderFill() throws IOException {
        ForPageBorderFill.read(this.secd.getOddPageBorderFill(), this.sr);
    }

    private void batangPageInfo() throws Exception {
        ForBatangPageInfo.read(this.secd.addNewBatangPageInfo(), this.sr);
    }

    private void ctrlData() throws IOException {
        this.secd.createCtrlData();
        ForCtrlData.read(this.secd.getCtrlData(), this.sr);
    }
}

