/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.bodytext.paragraph.control.bookmark;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.ParameterItem;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.ParameterSet;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.ParameterType;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForParameterSet {
    public static void read(ParameterSet ps, StreamReader sr) throws IOException {
        ps.setId(sr.readUInt2());
        int parameterCount = sr.readSInt2();
        sr.skip(2);
        for (int parameterIndex = 0; parameterIndex < parameterCount; ++parameterIndex) {
            ParameterItem pi = ps.addNewParameterItem();
            ForParameterSet.parameterItem(pi, sr);
        }
    }

    private static void parameterItem(ParameterItem pi, StreamReader sr) throws IOException {
        pi.setId(sr.readUInt2());
        pi.setType(ParameterType.valueOf(sr.readUInt2()));
        ForParameterSet.paramterValue(pi, sr);
    }

    private static void paramterValue(ParameterItem pi, StreamReader sr) throws IOException {
        switch (pi.getType()) {
            case NULL: {
                break;
            }
            case String: {
                pi.setValue_BSTR(sr.readUTF16LEString());
                break;
            }
            case Integer1: {
                pi.setValue_I1((byte)sr.readSInt4());
                break;
            }
            case Integer2: {
                pi.setValue_I2((short)sr.readSInt4());
                break;
            }
            case Integer4: {
                pi.setValue_I4(sr.readSInt4());
                break;
            }
            case Integer: {
                pi.setValue_I(sr.readSInt4());
                break;
            }
            case UnsignedInteger1: {
                pi.setValue_UI1((short)sr.readUInt4());
                break;
            }
            case UnsignedInteger2: {
                pi.setValue_UI2((int)sr.readUInt4());
                break;
            }
            case UnsignedInteger4: {
                pi.setValue_UI4(sr.readUInt4());
                break;
            }
            case UnsignedInteger: {
                pi.setValue_UI(sr.readUInt4());
                break;
            }
            case ParameterSet: {
                ForParameterSet.parameterSet(pi, sr);
                break;
            }
            case Array: {
                ForParameterSet.parameterArray(pi, sr);
                break;
            }
            case BINDataID: {
                pi.setValue_binData(sr.readUInt2());
            }
        }
    }

    private static void parameterSet(ParameterItem pi, StreamReader sr) throws IOException {
        pi.createValue_ParameterSet();
        ForParameterSet.read(pi.getValue_ParameterSet(), sr);
    }

    private static void parameterArray(ParameterItem pi, StreamReader sr) throws IOException {
        int count = sr.readSInt2();
        if (count > 0) {
            pi.createValue_ParameterArray(count);
            int id = sr.readUInt2();
            for (int index = 0; index < count; ++index) {
                ForParameterSet.parameterItemForArray(pi.getValue_ParameterArray(index), sr, id);
            }
        }
    }

    private static void parameterItemForArray(ParameterItem pi, StreamReader sr, int id) throws IOException {
        pi.setId(id);
        pi.setType(ParameterType.valueOf(sr.readUInt2()));
        ForParameterSet.paramterValue(pi, sr);
    }
}

