/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.part;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControlType;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.ShapeComponent;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.ShapeComponentContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.ShapeComponentNormal;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.lineinfo.LineInfo;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.lineinfo.OutlineStyle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.renderingnfo.Matrix;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.renderingnfo.RenderingInfo;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.renderingnfo.ScaleRotateMatrixPair;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.shadowinfo.ShadowInfo;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.shadowinfo.ShadowType;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.FillInfo;
import kr.dogfoot.hwplib.reader.docinfo.borderfill.ForFillInfo;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForShapeComponent {
    public static void read(GsoControl gsoControl, StreamReader sr) throws IOException {
        if (gsoControl.getGsoType() == GsoControlType.Container) {
            ForShapeComponent.shapeComponentForContainer((ShapeComponentContainer)gsoControl.getShapeComponent(), sr);
        } else {
            ForShapeComponent.shapeComponentForNormal((ShapeComponentNormal)gsoControl.getShapeComponent(), sr);
        }
    }

    private static void shapeComponentForNormal(ShapeComponentNormal scn, StreamReader sr) throws IOException {
        ForShapeComponent.commonPart(scn, sr);
        if (sr.isEndOfRecord()) {
            return;
        }
        ForShapeComponent.lineInfo(scn, sr);
        if (sr.isEndOfRecord()) {
            return;
        }
        ForShapeComponent.fillInfo(scn, sr);
        if (sr.isEndOfRecord()) {
            return;
        }
        ForShapeComponent.shadowInfo(scn, sr);
        if (sr.isEndOfRecord()) {
            return;
        }
        scn.setInstid(sr.readUInt4());
        sr.skip(1);
        scn.getShadowInfo().setTransparent(sr.readUInt1());
    }

    private static void commonPart(ShapeComponent sc, StreamReader sr) throws IOException {
        sc.setOffsetX(sr.readSInt4());
        sc.setOffsetY(sr.readSInt4());
        sc.setGroupingCount(sr.readUInt2());
        sc.setLocalFileVersion(sr.readUInt2());
        sc.setWidthAtCreate(sr.readSInt4());
        sc.setHeightAtCreate(sr.readSInt4());
        sc.setWidthAtCurrent(sr.readSInt4());
        sc.setHeightAtCurrent(sr.readSInt4());
        sc.getProperty().setValue(sr.readUInt4());
        sc.setRotateAngle(sr.readUInt2());
        sc.setRotateXCenter(sr.readSInt4());
        sc.setRotateYCenter(sr.readSInt4());
        ForShapeComponent.renderingInfo(sc.getRenderingInfo(), sr);
    }

    private static void renderingInfo(RenderingInfo ri, StreamReader sr) throws IOException {
        int scaleRotateMatrixCount = sr.readUInt2();
        ForShapeComponent.matrix(ri.getTranslationMatrix(), sr);
        for (int index = 0; index < scaleRotateMatrixCount; ++index) {
            ScaleRotateMatrixPair srmp = ri.addNewScaleRotateMatrixPair();
            ForShapeComponent.matrix(srmp.getScaleMatrix(), sr);
            ForShapeComponent.matrix(srmp.getRotateMatrix(), sr);
        }
    }

    private static void matrix(Matrix m, StreamReader sr) throws IOException {
        for (int index = 0; index < 6; ++index) {
            m.setValue(index, sr.readDouble());
        }
    }

    private static void lineInfo(ShapeComponentNormal scn, StreamReader sr) throws IOException {
        scn.createLineInfo();
        LineInfo li = scn.getLineInfo();
        li.getColor().setValue(sr.readUInt4());
        li.setThickness(sr.readSInt4());
        li.getProperty().setValue(sr.readUInt4());
        li.setOutlineStyle(OutlineStyle.valueOf((byte)sr.readUInt1()));
    }

    private static void fillInfo(ShapeComponentNormal scn, StreamReader sr) throws IOException {
        scn.createFillInfo();
        FillInfo fi = scn.getFillInfo();
        ForFillInfo.read(fi, sr);
    }

    private static void shadowInfo(ShapeComponentNormal scn, StreamReader sr) throws IOException {
        scn.createShadowInfo();
        ShadowInfo si = scn.getShadowInfo();
        si.setType(ShadowType.valueOf((byte)sr.readUInt4()));
        si.getColor().setValue(sr.readUInt4());
        si.setOffsetX(sr.readSInt4());
        si.setOffsetY(sr.readSInt4());
    }

    private static void shapeComponentForContainer(ShapeComponentContainer scc, StreamReader sr) throws IOException {
        ForShapeComponent.commonPart(scc, sr);
        ForShapeComponent.childInfo(scc, sr);
        if (sr.isEndOfRecord()) {
            return;
        }
        scc.setInstid(sr.readUInt4());
    }

    private static void childInfo(ShapeComponentContainer scc, StreamReader sr) throws IOException {
        int count = sr.readUInt2();
        for (int index = 0; index < count; ++index) {
            long childId = sr.readUInt4();
            scc.addChildControlId(childId);
        }
    }
}

