/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.bodytext.paragraph.control.tbl;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.ParameterItem;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.ParameterSet;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.ParameterType;
import kr.dogfoot.hwplib.object.bodytext.control.table.Cell;
import kr.dogfoot.hwplib.object.bodytext.control.table.ListHeaderForCell;
import kr.dogfoot.hwplib.reader.bodytext.ForParagraphList;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.bookmark.ForParameterSet;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForCell {
    public static void read(Cell cell, StreamReader sr) throws Exception {
        if (!sr.isImmediatelyAfterReadingHeader()) {
            sr.readRecordHeader();
        }
        if (sr.getCurrentRecordHeader().getTagID() != 72) {
            throw new Exception("cell's list header does not exist.");
        }
        ForCell.listHeader(cell.getListHeader(), sr);
        ForParagraphList.read(cell.getParagraphList(), sr);
    }

    private static void listHeader(ListHeaderForCell lh, StreamReader sr) throws IOException {
        lh.setParaCount(sr.readSInt4());
        lh.getProperty().setValue(sr.readUInt4());
        lh.setColIndex(sr.readUInt2());
        lh.setRowIndex(sr.readUInt2());
        lh.setColSpan(sr.readUInt2());
        lh.setRowSpan(sr.readUInt2());
        lh.setWidth(sr.readUInt4());
        lh.setHeight(sr.readUInt4());
        lh.setLeftMargin(sr.readUInt2());
        lh.setRightMargin(sr.readUInt2());
        lh.setTopMargin(sr.readUInt2());
        lh.setBottomMargin(sr.readUInt2());
        lh.setBorderFillId(sr.readUInt2());
        lh.setTextWidth(sr.readUInt4());
        if (sr.getCurrentRecordHeader().getSize() > sr.getCurrentPositionAfterHeader()) {
            short flag = sr.readUInt1();
            if (flag == 255) {
                ForCell.fieldName(lh, sr);
            }
            ForCell.unknownRestBytes(sr);
        }
    }

    private static void fieldName(ListHeaderForCell lh, StreamReader sr) throws IOException {
        ParameterSet ps = new ParameterSet();
        ForParameterSet.read(ps, sr);
        if (ps.getId() == 539) {
            for (ParameterItem pi : ps.getParameterItemList()) {
                if (pi.getId() != 16384L || pi.getType() != ParameterType.String) continue;
                lh.setFieldName(pi.getValue_BSTR());
            }
        }
    }

    private static void unknownRestBytes(StreamReader sr) throws IOException {
        sr.skipToEndRecord();
    }
}

