/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.docinfo;

import java.io.IOException;
import kr.dogfoot.hwplib.object.docinfo.BinData;
import kr.dogfoot.hwplib.object.docinfo.BorderFill;
import kr.dogfoot.hwplib.object.docinfo.Bullet;
import kr.dogfoot.hwplib.object.docinfo.CharShape;
import kr.dogfoot.hwplib.object.docinfo.DocInfo;
import kr.dogfoot.hwplib.object.docinfo.DocumentProperties;
import kr.dogfoot.hwplib.object.docinfo.FaceName;
import kr.dogfoot.hwplib.object.docinfo.IDMappings;
import kr.dogfoot.hwplib.object.docinfo.MemoShape;
import kr.dogfoot.hwplib.object.docinfo.Numbering;
import kr.dogfoot.hwplib.object.docinfo.ParaShape;
import kr.dogfoot.hwplib.object.docinfo.Style;
import kr.dogfoot.hwplib.object.docinfo.TabDef;
import kr.dogfoot.hwplib.object.etc.UnknownRecord;
import kr.dogfoot.hwplib.reader.ForUnknown;
import kr.dogfoot.hwplib.reader.docinfo.ForBinData;
import kr.dogfoot.hwplib.reader.docinfo.ForBorderFill;
import kr.dogfoot.hwplib.reader.docinfo.ForBullet;
import kr.dogfoot.hwplib.reader.docinfo.ForCharShape;
import kr.dogfoot.hwplib.reader.docinfo.ForCompatibleDocument;
import kr.dogfoot.hwplib.reader.docinfo.ForDocumentPropeties;
import kr.dogfoot.hwplib.reader.docinfo.ForFaceName;
import kr.dogfoot.hwplib.reader.docinfo.ForIDMappings;
import kr.dogfoot.hwplib.reader.docinfo.ForLayoutCompatibility;
import kr.dogfoot.hwplib.reader.docinfo.ForMemoShape;
import kr.dogfoot.hwplib.reader.docinfo.ForNumbering;
import kr.dogfoot.hwplib.reader.docinfo.ForParaShape;
import kr.dogfoot.hwplib.reader.docinfo.ForStyle;
import kr.dogfoot.hwplib.reader.docinfo.ForTabDef;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForDocInfo {
    private DocInfo docInfo;
    private StreamReader sr;

    public void read(DocInfo di, StreamReader sr) throws Exception {
        this.sr = sr;
        this.docInfo = di;
        while (!sr.isEndOfStream()) {
            sr.readRecordHeader();
            this.recordBody();
        }
    }

    private void recordBody() throws Exception {
        switch (this.sr.getCurrentRecordHeader().getTagID()) {
            case 16: {
                this.documentProperties(this.docInfo.getDocumentProperties());
                break;
            }
            case 17: {
                this.idMappings(this.docInfo.getIDMappings());
                break;
            }
            case 18: {
                this.binData();
                break;
            }
            case 19: {
                this.faceName();
                break;
            }
            case 20: {
                this.borderFill();
                break;
            }
            case 21: {
                this.charShape();
                break;
            }
            case 22: {
                this.tabDef();
                break;
            }
            case 23: {
                this.numbering();
                break;
            }
            case 24: {
                this.bullet();
                break;
            }
            case 25: {
                this.paraShape();
                break;
            }
            case 26: {
                this.style();
                break;
            }
            case 27: {
                this.docData();
                break;
            }
            case 94: {
                this.forbiddenChar();
                break;
            }
            case 28: {
                this.distributeDocData();
                break;
            }
            case 30: {
                this.compatibleDocument();
                break;
            }
            case 31: {
                this.layoutCompatibility();
                break;
            }
            case 32: {
                this.trackChange();
                break;
            }
            case 92: {
                this.memoShape();
                break;
            }
            case 96: {
                this.trackChange2();
                break;
            }
            case 97: {
                this.trackChangeAuthor();
            }
        }
    }

    private void documentProperties(DocumentProperties dp) throws IOException {
        ForDocumentPropeties.read(dp, this.sr);
    }

    private void idMappings(IDMappings im) throws IOException {
        ForIDMappings.read(im, this.sr);
    }

    private void binData() throws IOException {
        BinData bd = this.docInfo.addNewBinData();
        ForBinData.read(bd, this.sr);
    }

    private void faceName() throws Exception {
        FaceName fn = new FaceName();
        ForFaceName.read(fn, this.sr);
        this.addFaceNameByIDMappings(fn);
    }

    private void addFaceNameByIDMappings(FaceName fn) throws Exception {
        IDMappings idm = this.docInfo.getIDMappings();
        if (this.docInfo.getHangulFaceNameList().size() < idm.getHangulFaceNameCount()) {
            this.docInfo.getHangulFaceNameList().add(fn);
        } else if (this.docInfo.getEnglishFaceNameList().size() < idm.getEnglishFaceNameCount()) {
            this.docInfo.getEnglishFaceNameList().add(fn);
        } else if (this.docInfo.getHanjaFaceNameList().size() < idm.getHanjaFaceNameCount()) {
            this.docInfo.getHanjaFaceNameList().add(fn);
        } else if (this.docInfo.getJapaneseFaceNameList().size() < idm.getJapaneseFaceNameCount()) {
            this.docInfo.getJapaneseFaceNameList().add(fn);
        } else if (this.docInfo.getEtcFaceNameList().size() < idm.getEtcFaceNameCount()) {
            this.docInfo.getEtcFaceNameList().add(fn);
        } else if (this.docInfo.getSymbolFaceNameList().size() < idm.getSymbolFaceNameCount()) {
            this.docInfo.getSymbolFaceNameList().add(fn);
        } else if (this.docInfo.getUserFaceNameList().size() < idm.getUserFaceNameCount()) {
            this.docInfo.getUserFaceNameList().add(fn);
        } else {
            throw new Exception("Count of FaceName is greater than ID Mappings");
        }
    }

    private void borderFill() throws IOException {
        BorderFill bf = this.docInfo.addNewBorderFill();
        ForBorderFill.read(bf, this.sr);
    }

    private void charShape() throws Exception {
        CharShape cs = this.docInfo.addNewCharShape();
        ForCharShape.read(cs, this.sr);
    }

    private void tabDef() throws IOException {
        TabDef td = this.docInfo.addNewTabDef();
        ForTabDef.read(td, this.sr);
    }

    private void numbering() throws Exception {
        Numbering n = this.docInfo.addNewNumbering();
        ForNumbering.read(n, this.sr);
    }

    private void bullet() throws IOException {
        Bullet b = this.docInfo.addNewBullet();
        ForBullet.read(b, this.sr);
    }

    private void paraShape() throws IOException {
        ParaShape ps = this.docInfo.addNewParaShape();
        ForParaShape.read(ps, this.sr);
    }

    private void style() throws IOException {
        Style s = this.docInfo.addNewStyle();
        ForStyle.read(s, this.sr);
    }

    private void docData() throws IOException {
        this.docInfo.createDocData(this.sr.getCurrentRecordHeader());
        ForUnknown.read(this.docInfo.getDocData(), this.sr);
    }

    private void distributeDocData() throws IOException {
        this.docInfo.createDistributeDocData(this.sr.getCurrentRecordHeader());
        ForUnknown.read(this.docInfo.getDistributeDocData(), this.sr);
    }

    private void compatibleDocument() throws IOException {
        this.docInfo.createCompatibleDocument();
        ForCompatibleDocument.read(this.docInfo.getCompatibleDocument(), this.sr);
    }

    private void layoutCompatibility() throws IOException {
        this.docInfo.createLayoutCompatibility();
        ForLayoutCompatibility.read(this.docInfo.getLayoutCompatibility(), this.sr);
    }

    private void trackChange() throws IOException {
        this.docInfo.createTrackChange(this.sr.getCurrentRecordHeader());
        ForUnknown.read(this.docInfo.getTrackChange(), this.sr);
    }

    private void memoShape() throws IOException {
        MemoShape ms = this.docInfo.addNewMemoShape();
        ForMemoShape.read(ms, this.sr);
    }

    private void forbiddenChar() throws IOException {
        this.docInfo.createForbiddenChar(this.sr.getCurrentRecordHeader());
        ForUnknown.read(this.docInfo.getForbiddenChar(), this.sr);
    }

    private void trackChange2() throws IOException {
        UnknownRecord ur = this.docInfo.addNewTrackChange2(this.sr.getCurrentRecordHeader());
        ForUnknown.read(ur, this.sr);
    }

    private void trackChangeAuthor() throws IOException {
        UnknownRecord ur = this.docInfo.addNewTrackChangeAuthor(this.sr.getCurrentRecordHeader());
        ForUnknown.read(ur, this.sr);
    }
}

