/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.objectfinder;

import java.util.ArrayList;
import kr.dogfoot.hwplib.object.HWPFile;
import kr.dogfoot.hwplib.object.bodytext.ParagraphListInterface;
import kr.dogfoot.hwplib.object.bodytext.Section;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFooter;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHiddenComment;
import kr.dogfoot.hwplib.object.bodytext.control.ControlTable;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlArc;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlEllipse;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPolygon;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlRectangle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.gso.textbox.TextBox;
import kr.dogfoot.hwplib.object.bodytext.control.table.Cell;
import kr.dogfoot.hwplib.object.bodytext.control.table.Row;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;

public class CellFinder {
    private ArrayList<Cell> cellList = new ArrayList();
    private String fieldName;

    private CellFinder(String fieldName) {
        this.fieldName = fieldName;
    }

    public static ArrayList<Cell> findAll(ControlTable table, String fieldName) {
        CellFinder finder = new CellFinder(fieldName);
        finder.find(table);
        return finder.cellList;
    }

    public static ArrayList<Cell> findAll(HWPFile hwpFile, String fieldName) {
        CellFinder finder = new CellFinder(fieldName);
        for (Section s : hwpFile.getBodyText().getSectionList()) {
            finder.forParagraphList(s);
        }
        return finder.cellList;
    }

    public void find(ControlTable table) {
        for (Row row : table.getRowList()) {
            for (Cell cell : row.getCellList()) {
                if (this.matchFieldName(cell, this.fieldName)) {
                    this.cellList.add(cell);
                }
                this.forParagraphList(cell.getParagraphList());
            }
        }
    }

    private boolean matchFieldName(Cell cell, String fieldName) {
        return cell != null && cell.getListHeader().getFieldName() != null && cell.getListHeader().getFieldName().equals(fieldName);
    }

    private void forParagraphList(ParagraphListInterface paragraphs) {
        for (Paragraph p : paragraphs) {
            if (p.getControlList() == null) continue;
            for (Control c : p.getControlList()) {
                this.forControl(c);
            }
        }
    }

    private void forControl(Control c) {
        switch (c.getType()) {
            case Table: {
                this.find((ControlTable)c);
                break;
            }
            case Gso: {
                this.forGso((GsoControl)c);
                break;
            }
            case Header: {
                ControlHeader header = (ControlHeader)c;
                this.forParagraphList(header.getParagraphList());
                break;
            }
            case Footer: {
                ControlFooter footer = (ControlFooter)c;
                this.forParagraphList(footer.getParagraphList());
                break;
            }
            case Footnote: {
                ControlFootnote footnote = (ControlFootnote)c;
                this.forParagraphList(footnote.getParagraphList());
                break;
            }
            case Endnote: {
                ControlEndnote endnote = (ControlEndnote)c;
                this.forParagraphList(endnote.getParagraphList());
                break;
            }
            case HiddenComment: {
                ControlHiddenComment comment = (ControlHiddenComment)c;
                this.forParagraphList(comment.getParagraphList());
                break;
            }
        }
    }

    private void forGso(GsoControl gso) {
        switch (gso.getGsoType()) {
            case Rectangle: {
                ControlRectangle rectangle = (ControlRectangle)gso;
                this.forTextBox(rectangle.getTextBox());
                break;
            }
            case Ellipse: {
                ControlEllipse ellipse = (ControlEllipse)gso;
                this.forTextBox(ellipse.getTextBox());
                break;
            }
            case Arc: {
                ControlArc arc = (ControlArc)gso;
                this.forTextBox(arc.getTextBox());
                break;
            }
            case Polygon: {
                ControlPolygon polygon = (ControlPolygon)gso;
                this.forTextBox(polygon.getTextBox());
                break;
            }
            case Curve: {
                ControlCurve curve = (ControlCurve)gso;
                this.forTextBox(curve.getTextBox());
                break;
            }
            case Container: {
                ControlContainer container = (ControlContainer)gso;
                for (Control control : container.getChildControlList()) {
                    this.forControl(control);
                }
                break;
            }
        }
    }

    private void forTextBox(TextBox textBox) {
        if (textBox == null) {
            return;
        }
        this.forParagraphList(textBox.getParagraphList());
    }
}

