/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.objectfinder;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import kr.dogfoot.hwplib.object.HWPFile;
import kr.dogfoot.hwplib.object.bodytext.Section;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.tool.objectfinder.SetFieldResult;
import kr.dogfoot.hwplib.tool.objectfinder.TextBuffer;
import kr.dogfoot.hwplib.tool.objectfinder.forField.ForParagraphList;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractMethod;

public class FieldFinder {
    public static String getClickHereText(HWPFile hwpFile, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        Section s;
        String strText = null;
        Iterator<Section> iterator = hwpFile.getBodyText().getSectionList().iterator();
        while (iterator.hasNext() && (strText = ForParagraphList.getFieldText(s = iterator.next(), ControlType.FIELD_CLICKHERE, fieldName, temInField)) == null) {
        }
        return strText;
    }

    public static ArrayList<String> getAllClickHereText(HWPFile hwpFile, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        ArrayList<String> textList = new ArrayList<String>();
        for (Section s : hwpFile.getBodyText().getSectionList()) {
            ForParagraphList.getAllFieldText(s, ControlType.FIELD_CLICKHERE, fieldName, temInField, textList);
        }
        return textList;
    }

    public static SetFieldResult setClickHereText(HWPFile hwpFile, String fieldName, ArrayList<String> textList) throws UnsupportedEncodingException {
        if (textList.size() == 0) {
            return SetFieldResult.ETCError;
        }
        TextBuffer textBuffer = new TextBuffer(textList);
        for (Section s : hwpFile.getBodyText().getSectionList()) {
            if (ForParagraphList.setFieldText(s, ControlType.FIELD_CLICKHERE, fieldName, textBuffer) != SetFieldResult.NotEnoughText) continue;
            return SetFieldResult.NotEnoughText;
        }
        if (textBuffer.usedAll()) {
            return SetFieldResult.SetAllText;
        }
        if (textBuffer.notUsed()) {
            return SetFieldResult.NotFound;
        }
        return SetFieldResult.TextRemains;
    }

    public static String getFieldText(HWPFile hwpFile, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        Section s;
        String strText = null;
        Iterator<Section> iterator = hwpFile.getBodyText().getSectionList().iterator();
        while (iterator.hasNext() && (strText = ForParagraphList.getFieldText(s = iterator.next(), fieldType, fieldName, temInField)) == null) {
        }
        return strText;
    }

    public static ArrayList<String> getAllFieldText(HWPFile hwpFile, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        ArrayList<String> textList = new ArrayList<String>();
        for (Section s : hwpFile.getBodyText().getSectionList()) {
            ForParagraphList.getAllFieldText(s, fieldType, fieldName, temInField, textList);
        }
        return textList;
    }

    public static SetFieldResult setFieldText(HWPFile hwpFile, ControlType fieldType, String fieldName, ArrayList<String> textList) throws UnsupportedEncodingException {
        if (!fieldType.isField() || textList.size() == 0) {
            return SetFieldResult.ETCError;
        }
        TextBuffer textBuffer = new TextBuffer(textList);
        for (Section s : hwpFile.getBodyText().getSectionList()) {
            if (ForParagraphList.setFieldText(s, fieldType, fieldName, textBuffer) != SetFieldResult.NotEnoughText) continue;
            return SetFieldResult.NotEnoughText;
        }
        if (textBuffer.usedAll()) {
            return SetFieldResult.SetAllText;
        }
        if (textBuffer.notUsed()) {
            return SetFieldResult.NotFound;
        }
        return SetFieldResult.TextRemains;
    }
}

