/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.objectfinder.fieldform;

import java.util.ArrayList;
import kr.dogfoot.hwplib.object.HWPFile;
import kr.dogfoot.hwplib.object.bodytext.ParagraphListInterface;
import kr.dogfoot.hwplib.object.bodytext.Section;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlField;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPChar;
import kr.dogfoot.hwplib.tool.objectfinder.fieldform.FieldData;
import kr.dogfoot.hwplib.tool.objectfinder.fieldform.FieldType;
import kr.dogfoot.hwplib.tool.objectfinder.fieldform.ForControl;
import kr.dogfoot.hwplib.tool.objectfinder.fieldform.FormData;

public class FieldFormFinder {
    public static Result findAll(HWPFile hwpFile) {
        return FieldFormFinder.find(hwpFile, new Option(null, false, true, true, true, true));
    }

    public static Result find(HWPFile hwpFile, Option option) {
        Result result = new Result();
        for (Section section : hwpFile.getBodyText().getSectionList()) {
            try {
                FieldFormFinder.findInParagraphList(section, result, option);
            }
            catch (StopFindException e) {
                break;
            }
        }
        return result;
    }

    public static void findInParagraphList(ParagraphListInterface paragraphList, Result result, Option option) throws StopFindException {
        StopFindException exception = null;
        if (option.nameToFind() != null && option.onlyFirst() && result.added()) {
            throw new StopFindException();
        }
        if (option.findField()) {
            ArrayList<FieldData> resultInParagraphList = new ArrayList<FieldData>();
            try {
                FieldFormFinder.getFieldStartPosition(paragraphList, resultInParagraphList, option);
            }
            catch (StopFindException e) {
                exception = e;
            }
            for (FieldData fieldData : resultInParagraphList) {
                FieldFormFinder.getFieldEndPosition(paragraphList, fieldData);
            }
            result.addAllFieldData(resultInParagraphList);
        }
        if (exception != null) {
            throw exception;
        }
        for (Paragraph paragraph : paragraphList) {
            if (paragraph.getControlList() == null) continue;
            ForControl.findInControlList(paragraph.getControlList(), result, option);
        }
    }

    private static void getFieldStartPosition(ParagraphListInterface paragraphList, ArrayList<FieldData> result, Option option) throws StopFindException {
        int paraCount = paragraphList.getParagraphCount();
        for (int paraIndex = 0; paraIndex < paraCount; ++paraIndex) {
            FieldFormFinder.findStartingField(paragraphList, paraIndex, result, option);
        }
    }

    private static void findStartingField(ParagraphListInterface paragraphList, int paraIndex, ArrayList<FieldData> results, Option option) throws StopFindException {
        Paragraph p = paragraphList.getParagraph(paraIndex);
        if (p.getControlList() == null) {
            return;
        }
        int ctrlCount = p.getControlList().size();
        for (int ctrlIndex = 0; ctrlIndex < ctrlCount; ++ctrlIndex) {
            Control c = p.getControlList().get(ctrlIndex);
            if (!c.isField()) continue;
            ControlField field = (ControlField)c;
            if (option.nameToFind() != null) {
                if (!option.nameToFind().equals(field.getName())) continue;
                FieldFormFinder.addStartingField(paragraphList, paraIndex, results, p, ctrlIndex, field);
                if (!option.onlyFirst()) continue;
                throw new StopFindException();
            }
            FieldFormFinder.addStartingField(paragraphList, paraIndex, results, p, ctrlIndex, field);
        }
    }

    private static void addStartingField(ParagraphListInterface paragraphList, int paraIndex, ArrayList<FieldData> results, Paragraph p, int ctrlIndex, ControlField field) {
        FieldData fieldData = new FieldData(field.getName(), field.getType() == ControlType.FIELD_CLICKHERE ? FieldType.ClickHere : FieldType.ETC, null, paragraphList);
        fieldData.setStartPosition(paraIndex, p.getText().getCharIndexFromExtendCharIndex(ctrlIndex));
        results.add(fieldData);
    }

    private static void getFieldEndPosition(ParagraphListInterface paragraphList, FieldData fieldData) {
        int depth = 0;
        int paraCount = paragraphList.getParagraphCount();
        for (int paraIndex = fieldData.getStartParaIndex(); paraIndex < paraCount; ++paraIndex) {
            Paragraph p = paragraphList.getParagraph(paraIndex);
            if (p.getText() == null) continue;
            int startIndex = paraIndex == fieldData.getStartParaIndex() ? fieldData.getStartCharIndex() + 1 : 0;
            int charCount = p.getText().getCharList().size();
            for (int charIndex = startIndex; charIndex < charCount; ++charIndex) {
                HWPChar hwpChar = p.getText().getCharList().get(charIndex);
                if (hwpChar.getCode() == 3) {
                    ++depth;
                    continue;
                }
                if (hwpChar.getCode() != 4) continue;
                if (depth == 0) {
                    fieldData.setEndPosition(paraIndex, charIndex);
                    return;
                }
                --depth;
            }
        }
    }

    public static class StopFindException
    extends Exception {
    }

    public static class Option {
        private String nameToFind;
        private boolean onlyFirst;
        private boolean findField;
        private boolean findGso;
        private boolean findCell;
        private boolean findForm;

        public Option(String nameToFind, boolean onlyFirst, boolean findField, boolean findGso, boolean findCell, boolean findForm) {
            this.nameToFind = nameToFind;
            this.onlyFirst = onlyFirst;
            this.findField = findField;
            this.findGso = findGso;
            this.findCell = findCell;
            this.findForm = findForm;
        }

        public String nameToFind() {
            return this.nameToFind;
        }

        public void nameToFind(String nameToFind) {
            this.nameToFind = nameToFind;
        }

        public boolean onlyFirst() {
            return this.onlyFirst;
        }

        public void onlyFirst(boolean onlyFirst) {
            this.onlyFirst = onlyFirst;
        }

        public boolean findField() {
            return this.findField;
        }

        public void findField(boolean findField) {
            this.findField = findField;
        }

        public boolean findGso() {
            return this.findGso;
        }

        public void findGso(boolean findGso) {
            this.findGso = findGso;
        }

        public boolean findCell() {
            return this.findCell;
        }

        public void findCell(boolean findCell) {
            this.findCell = findCell;
        }

        public boolean findForm() {
            return this.findForm;
        }

        public void findForm(boolean findForm) {
            this.findForm = findForm;
        }
    }

    public static class Result {
        private ArrayList<FieldData> fieldDataList = new ArrayList();
        private ArrayList<FormData> formDataList = new ArrayList();
        private boolean added = false;

        public void addFieldData(FieldData fieldData) {
            this.fieldDataList.add(fieldData);
            if (fieldData != null) {
                this.added = true;
            }
        }

        public void addAllFieldData(ArrayList<FieldData> fieldDataList) {
            this.fieldDataList.addAll(fieldDataList);
            if (fieldDataList.size() > 0) {
                this.added = true;
            }
        }

        public ArrayList<FieldData> getFieldDataList() {
            return this.fieldDataList;
        }

        public void addFormData(FormData formData) {
            this.formDataList.add(formData);
            if (formData != null) {
                this.added = true;
            }
        }

        public ArrayList<FormData> getFormDataList() {
            return this.formDataList;
        }

        public boolean added() {
            return this.added;
        }
    }
}

