/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.objectfinder.forField.settext;

import java.io.UnsupportedEncodingException;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlArc;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlEllipse;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPolygon;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlRectangle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.gso.textbox.TextBox;
import kr.dogfoot.hwplib.tool.objectfinder.SetFieldResult;
import kr.dogfoot.hwplib.tool.objectfinder.TextBuffer;
import kr.dogfoot.hwplib.tool.objectfinder.forField.ForParagraphList;

public class ForGso {
    public static SetFieldResult setFieldText(GsoControl gc, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        switch (gc.getGsoType()) {
            case Line: {
                break;
            }
            case Rectangle: {
                return ForGso.rectangle((ControlRectangle)gc, fieldType, fieldName, textBuffer);
            }
            case Ellipse: {
                return ForGso.ellipse((ControlEllipse)gc, fieldType, fieldName, textBuffer);
            }
            case Arc: {
                return ForGso.arc((ControlArc)gc, fieldType, fieldName, textBuffer);
            }
            case Polygon: {
                return ForGso.polygon((ControlPolygon)gc, fieldType, fieldName, textBuffer);
            }
            case Curve: {
                return ForGso.curve((ControlCurve)gc, fieldType, fieldName, textBuffer);
            }
            case Picture: {
                break;
            }
            case OLE: {
                break;
            }
            case Container: {
                return ForGso.container((ControlContainer)gc, fieldType, fieldName, textBuffer);
            }
        }
        return SetFieldResult.InProcess;
    }

    private static SetFieldResult rectangle(ControlRectangle rectangle, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        return ForGso.textBox(rectangle.getTextBox(), fieldType, fieldName, textBuffer);
    }

    private static SetFieldResult textBox(TextBox textBox, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        if (textBox == null) {
            return SetFieldResult.InProcess;
        }
        return ForParagraphList.setFieldText(textBox.getParagraphList(), fieldType, fieldName, textBuffer);
    }

    private static SetFieldResult ellipse(ControlEllipse ellipse, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        return ForGso.textBox(ellipse.getTextBox(), fieldType, fieldName, textBuffer);
    }

    private static SetFieldResult arc(ControlArc arc, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        return ForGso.textBox(arc.getTextBox(), fieldType, fieldName, textBuffer);
    }

    private static SetFieldResult polygon(ControlPolygon polygon, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        return ForGso.textBox(polygon.getTextBox(), fieldType, fieldName, textBuffer);
    }

    private static SetFieldResult curve(ControlCurve curve, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        return ForGso.textBox(curve.getTextBox(), fieldType, fieldName, textBuffer);
    }

    private static SetFieldResult container(ControlContainer container, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        for (GsoControl child : container.getChildControlList()) {
            if (ForGso.setFieldText(child, fieldType, fieldName, textBuffer) != SetFieldResult.NotEnoughText) continue;
            return SetFieldResult.NotEnoughText;
        }
        return SetFieldResult.InProcess;
    }
}

