/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder;

import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlAdditionalText;
import kr.dogfoot.hwplib.object.bodytext.control.ControlAutoNumber;
import kr.dogfoot.hwplib.object.bodytext.control.ControlBookmark;
import kr.dogfoot.hwplib.object.bodytext.control.ControlColumnDefine;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEquation;
import kr.dogfoot.hwplib.object.bodytext.control.ControlField;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFooter;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlForm;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHiddenComment;
import kr.dogfoot.hwplib.object.bodytext.control.ControlIndexMark;
import kr.dogfoot.hwplib.object.bodytext.control.ControlNewNumber;
import kr.dogfoot.hwplib.object.bodytext.control.ControlOverlappingLetter;
import kr.dogfoot.hwplib.object.bodytext.control.ControlPageHide;
import kr.dogfoot.hwplib.object.bodytext.control.ControlPageNumberPosition;
import kr.dogfoot.hwplib.object.bodytext.control.ControlPageOddEvenAdjust;
import kr.dogfoot.hwplib.object.bodytext.control.ControlSectionDefine;
import kr.dogfoot.hwplib.object.bodytext.control.ControlTable;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.object.bodytext.paragraph.ParagraphList;
import kr.dogfoot.hwplib.object.bodytext.paragraph.charshape.CharPositionShapeIdPair;
import kr.dogfoot.hwplib.object.bodytext.paragraph.header.ParaHeader;
import kr.dogfoot.hwplib.object.bodytext.paragraph.lineseg.LineSegItem;
import kr.dogfoot.hwplib.object.bodytext.paragraph.rangetag.RangeTagItem;
import kr.dogfoot.hwplib.tool.paragraphadder.ParaTextCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.AdditionalTextCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.ETCControlCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.EquationCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.GsoCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.OverlappingLetterCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.SectionDefineCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.TableCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;

public class ParagraphCopier {
    private DocInfoAdder docInfoAdder;
    private Paragraph source;
    private Paragraph target;
    private boolean includingSectionInfo;
    private boolean excludedSectionDefine;

    public static void listCopy(ParagraphList source, ParagraphList target, DocInfoAdder docInfoAdder) {
        ParagraphCopier copier = new ParagraphCopier(docInfoAdder);
        for (Paragraph p : source) {
            try {
                copier.copy(p, target.addNewParagraph());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ParagraphCopier(DocInfoAdder docInfoAdder) {
        this.docInfoAdder = docInfoAdder;
    }

    public void copy(Paragraph source, Paragraph target) throws Exception {
        this.source = source;
        this.target = target;
        this.includingSectionInfo = false;
        this.copyHeader();
        this.copyText();
        this.copyCharShape();
        this.copyLineSeg();
        this.copyRangeTag();
        this.copyControlList();
        this.copyMemoList();
    }

    public void copyIncludingSectionInfo(Paragraph source, Paragraph target) throws Exception {
        this.source = source;
        this.target = target;
        this.includingSectionInfo = true;
        this.copyHeader();
        this.copyText();
        this.copyCharShape();
        this.copyLineSeg();
        this.copyRangeTag();
        this.copyControlList();
        this.copyMemoList();
    }

    private void copyHeader() {
        if (this.source.getHeader() != null) {
            ParaHeader sourceH = this.source.getHeader();
            ParaHeader targetH = this.target.getHeader();
            targetH.setLastInList(sourceH.isLastInList());
            targetH.setCharacterCount(sourceH.getCharacterCount());
            targetH.getControlMask().setValue(sourceH.getControlMask().getValue());
            targetH.setParaShapeId(this.docInfoAdder == null ? sourceH.getParaShapeId() : this.docInfoAdder.forParaShape().processById(sourceH.getParaShapeId()));
            targetH.setStyleId(this.docInfoAdder == null ? sourceH.getStyleId() : (short)this.docInfoAdder.forStyle().processById(sourceH.getStyleId()));
            targetH.getDivideSort().setValue(sourceH.getDivideSort().getValue());
            targetH.setCharShapeCount(sourceH.getCharShapeCount());
            targetH.setRangeTagCount(sourceH.getRangeTagCount());
            targetH.setLineAlignCount(sourceH.getLineAlignCount());
            targetH.setInstanceID(0L);
            targetH.setIsMergedByTrack(sourceH.getIsMergedByTrack());
        }
    }

    private void copyText() throws Exception {
        if (this.source.getText() != null) {
            this.target.createText();
            this.excludedSectionDefine = ParaTextCopier.copy(this.source.getText(), this.target.getText(), this.includingSectionInfo);
        }
    }

    private void copyCharShape() {
        if (this.source.getCharShape() != null) {
            this.target.createCharShape();
            for (CharPositionShapeIdPair cpsp : this.source.getCharShape().getPositonShapeIdPairList()) {
                if (this.excludedSectionDefine && cpsp.getPosition() > 0L) {
                    this.target.getCharShape().addParaCharShape(cpsp.getPosition() - 8L, this.docInfoAdder == null ? cpsp.getShapeId() : (long)this.docInfoAdder.forCharShape().processById((int)cpsp.getShapeId()));
                    continue;
                }
                this.target.getCharShape().addParaCharShape(cpsp.getPosition(), this.docInfoAdder == null ? cpsp.getShapeId() : (long)this.docInfoAdder.forCharShape().processById((int)cpsp.getShapeId()));
            }
        }
    }

    private void copyLineSeg() {
        if (this.source.getLineSeg() != null) {
            this.target.createLineSeg();
            for (LineSegItem lsi : this.source.getLineSeg().getLineSegItemList()) {
                this.target.getLineSeg().getLineSegItemList().add(lsi.clone());
            }
        }
    }

    private void copyRangeTag() throws Exception {
        if (this.source.getRangeTag() != null) {
            this.target.createRangeTag();
            for (RangeTagItem rti : this.source.getRangeTag().getRangeTagItemList()) {
                this.target.getRangeTag().getRangeTagItemList().add(rti.clone());
            }
        }
    }

    private void copyControlList() {
        if (this.source.getControlList() == null) {
            return;
        }
        for (Control c : this.source.getControlList()) {
            switch (c.getType()) {
                case Table: {
                    TableCopier.copy((ControlTable)c, (ControlTable)this.target.addNewControl(ControlType.Table), this.docInfoAdder);
                    break;
                }
                case Gso: {
                    GsoCopier.copy((GsoControl)c, this.target.addNewGsoControl(((GsoControl)c).getGsoType()), this.docInfoAdder);
                    break;
                }
                case Equation: {
                    EquationCopier.copy((ControlEquation)c, (ControlEquation)this.target.addNewControl(ControlType.Equation), this.docInfoAdder);
                    break;
                }
                case SectionDefine: {
                    if (!this.includingSectionInfo) break;
                    SectionDefineCopier.copy((ControlSectionDefine)c, (ControlSectionDefine)this.target.addNewControl(ControlType.SectionDefine), this.docInfoAdder);
                    break;
                }
                case ColumnDefine: {
                    ETCControlCopier.copyColumnDefine((ControlColumnDefine)c, (ControlColumnDefine)this.target.addNewControl(ControlType.ColumnDefine), this.docInfoAdder);
                    break;
                }
                case Header: {
                    if (!this.includingSectionInfo) break;
                    ETCControlCopier.copyHeader((ControlHeader)c, (ControlHeader)this.target.addNewControl(ControlType.Header), this.docInfoAdder);
                    break;
                }
                case Footer: {
                    if (!this.includingSectionInfo) break;
                    ETCControlCopier.copyFooter((ControlFooter)c, (ControlFooter)this.target.addNewControl(ControlType.Footer), this.docInfoAdder);
                    break;
                }
                case Footnote: {
                    ETCControlCopier.copyFootnote((ControlFootnote)c, (ControlFootnote)this.target.addNewControl(ControlType.Footnote), this.docInfoAdder);
                    break;
                }
                case Endnote: {
                    ETCControlCopier.copyEndnote((ControlEndnote)c, (ControlEndnote)this.target.addNewControl(ControlType.Endnote), this.docInfoAdder);
                    break;
                }
                case AutoNumber: {
                    ETCControlCopier.copyAutoNumber((ControlAutoNumber)c, (ControlAutoNumber)this.target.addNewControl(ControlType.AutoNumber), this.docInfoAdder);
                    break;
                }
                case NewNumber: {
                    ETCControlCopier.copyNewNumber((ControlNewNumber)c, (ControlNewNumber)this.target.addNewControl(ControlType.NewNumber), this.docInfoAdder);
                    break;
                }
                case PageHide: {
                    ETCControlCopier.copyPageHide((ControlPageHide)c, (ControlPageHide)this.target.addNewControl(ControlType.PageHide), this.docInfoAdder);
                    break;
                }
                case PageOddEvenAdjust: {
                    ETCControlCopier.copyPageOddEvenAdjust((ControlPageOddEvenAdjust)c, (ControlPageOddEvenAdjust)this.target.addNewControl(ControlType.PageOddEvenAdjust), this.docInfoAdder);
                    break;
                }
                case PageNumberPosition: {
                    ETCControlCopier.copyPageNumberPosition((ControlPageNumberPosition)c, (ControlPageNumberPosition)this.target.addNewControl(ControlType.PageNumberPosition), this.docInfoAdder);
                    break;
                }
                case IndexMark: {
                    ETCControlCopier.copyIndexMark((ControlIndexMark)c, (ControlIndexMark)this.target.addNewControl(ControlType.IndexMark), this.docInfoAdder);
                    break;
                }
                case Bookmark: {
                    ETCControlCopier.copyBookmark((ControlBookmark)c, (ControlBookmark)this.target.addNewControl(ControlType.Bookmark), this.docInfoAdder);
                    break;
                }
                case OverlappingLetter: {
                    OverlappingLetterCopier.copy((ControlOverlappingLetter)c, (ControlOverlappingLetter)this.target.addNewControl(ControlType.OverlappingLetter), this.docInfoAdder);
                    break;
                }
                case AdditionalText: {
                    AdditionalTextCopier.copy((ControlAdditionalText)c, (ControlAdditionalText)this.target.addNewControl(ControlType.AdditionalText), this.docInfoAdder);
                    break;
                }
                case HiddenComment: {
                    ETCControlCopier.copyHiddenComment((ControlHiddenComment)c, (ControlHiddenComment)this.target.addNewControl(ControlType.HiddenComment), this.docInfoAdder);
                    break;
                }
                case Form: {
                    ETCControlCopier.copyForm((ControlForm)c, (ControlForm)this.target.addNewControl(ControlType.Form), this.docInfoAdder);
                    break;
                }
                case FIELD_UNKNOWN: 
                case FIELD_DATE: 
                case FIELD_DOCDATE: 
                case FIELD_PATH: 
                case FIELD_BOOKMARK: 
                case FIELD_MAILMERGE: 
                case FIELD_CROSSREF: 
                case FIELD_FORMULA: 
                case FIELD_CLICKHERE: 
                case FIELD_SUMMARY: 
                case FIELD_USERINFO: 
                case FIELD_HYPERLINK: 
                case FIELD_REVISION_SIGN: 
                case FIELD_REVISION_DELETE: 
                case FIELD_REVISION_ATTACH: 
                case FIELD_REVISION_CLIPPING: 
                case FIELD_REVISION_THINKING: 
                case FIELD_REVISION_PRAISE: 
                case FIELD_REVISION_LINE: 
                case FIELD_REVISION_SIMPLECHANGE: 
                case FIELD_REVISION_HYPERLINK: 
                case FIELD_REVISION_LINEATTACH: 
                case FIELD_REVISION_LINELINK: 
                case FIELD_REVISION_LINETRANSFER: 
                case FIELD_REVISION_RIGHTMOVE: 
                case FIELD_REVISION_LEFTMOVE: 
                case FIELD_REVISION_TRANSFER: 
                case FIELD_REVISION_SIMPLEINSERT: 
                case FIELD_REVISION_SPLIT: 
                case FIELD_REVISION_CHANGE: 
                case FIELD_MEMO: 
                case FIELD_PRIVATE_INFO_SECURITY: 
                case FIELD_TABLEOFCONTENTS: {
                    ETCControlCopier.copyField((ControlField)c, (ControlField)this.target.addNewControl(((ControlField)c).getHeader().getCtrlId()), this.docInfoAdder);
                }
            }
        }
    }

    private void copyMemoList() {
        ParagraphCopier.copyMemoList(this.source, this.target, this.docInfoAdder);
    }

    public static void copyMemoList(Paragraph source, Paragraph target, DocInfoAdder docInfoAdder) {
    }
}

