/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder.docinfo;

import java.util.HashMap;
import kr.dogfoot.hwplib.object.docinfo.CharShape;
import kr.dogfoot.hwplib.object.docinfo.charshape.CharOffsets;
import kr.dogfoot.hwplib.object.docinfo.charshape.CharSpaces;
import kr.dogfoot.hwplib.object.docinfo.charshape.FaceNameIds;
import kr.dogfoot.hwplib.object.docinfo.charshape.Ratios;
import kr.dogfoot.hwplib.object.docinfo.charshape.RelativeSizes;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;

public class CharShapeAdder {
    private DocInfoAdder docInfoAdder;
    private HashMap<Integer, Integer> idMatchingMap;

    public CharShapeAdder(DocInfoAdder docInfoAdder) {
        this.docInfoAdder = docInfoAdder;
        this.idMatchingMap = new HashMap();
    }

    public int processById(int sourceId) {
        CharShape source;
        if (this.docInfoAdder.getSourceHWPFile() == this.docInfoAdder.getTargetHWPFile()) {
            return sourceId;
        }
        if (this.idMatchingMap.containsKey(sourceId)) {
            return this.idMatchingMap.get(sourceId);
        }
        try {
            source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getCharShapeList().get(sourceId);
        }
        catch (Exception e) {
            return sourceId;
        }
        int id = this.findFromTarget(source);
        if (id == -1) {
            id = this.addAndCopy(source);
        }
        this.idMatchingMap.put(sourceId, id);
        return id;
    }

    private int findFromTarget(CharShape source) {
        int count = this.docInfoAdder.getTargetHWPFile().getDocInfo().getCharShapeList().size();
        for (int index = 0; index < count; ++index) {
            CharShape target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getCharShapeList().get(index);
            if (!this.equal(source, target)) continue;
            return index;
        }
        return -1;
    }

    public boolean equal(CharShape source, CharShape target) {
        return this.equalFaceNameIds(source.getFaceNameIds(), target.getFaceNameIds()) && this.equalRatios(source.getRatios(), target.getRatios()) && this.equalCharSpaces(source.getCharSpaces(), target.getCharSpaces()) && this.equalRelativeSizes(source.getRelativeSizes(), target.getRelativeSizes()) && this.equalCharOffsets(source.getCharOffsets(), target.getCharOffsets()) && source.getBaseSize() == target.getBaseSize() && source.getProperty().getValue() == target.getProperty().getValue() && source.getShadowGap1() == target.getShadowGap1() && source.getShadowGap2() == target.getShadowGap2() && source.getCharColor().getValue() == target.getCharColor().getValue() && source.getUnderLineColor().getValue() == target.getUnderLineColor().getValue() && source.getShadeColor().getValue() == target.getShadeColor().getValue() && source.getShadowColor().getValue() == target.getShadowColor().getValue() && this.docInfoAdder.forBorderFill().equalById(source.getBorderFillId(), target.getBorderFillId()) && source.getStrikeLineColor().getValue() == target.getStrikeLineColor().getValue();
    }

    private boolean equalFaceNameIds(FaceNameIds source, FaceNameIds target) {
        return this.docInfoAdder.forFaceName().equalByHangulId(source.getHangul(), target.getHangul()) && this.docInfoAdder.forFaceName().equalByLatinId(source.getLatin(), target.getLatin()) && this.docInfoAdder.forFaceName().equalByHanjaId(source.getHanja(), target.getHanja()) && this.docInfoAdder.forFaceName().equalByJapaneseId(source.getJapanese(), target.getJapanese()) && this.docInfoAdder.forFaceName().equalByOtherId(source.getOther(), target.getOther()) && this.docInfoAdder.forFaceName().equalBySymbolId(source.getSymbol(), target.getSymbol()) && this.docInfoAdder.forFaceName().equalByUserId(source.getUser(), target.getUser());
    }

    private boolean equalRatios(Ratios source, Ratios target) {
        short[] targetArray;
        short[] sourceArray = source.getArray();
        if (sourceArray.length == (targetArray = target.getArray()).length) {
            for (int index = 0; index < 7; ++index) {
                if (sourceArray[index] == targetArray[index]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean equalCharSpaces(CharSpaces source, CharSpaces target) {
        byte[] targetArray;
        byte[] sourceArray = source.getArray();
        if (sourceArray.length == (targetArray = target.getArray()).length) {
            for (int index = 0; index < 7; ++index) {
                if (sourceArray[index] == targetArray[index]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean equalRelativeSizes(RelativeSizes source, RelativeSizes target) {
        short[] targetArray;
        short[] sourceArray = source.getArray();
        if (sourceArray.length == (targetArray = target.getArray()).length) {
            for (int index = 0; index < 7; ++index) {
                if (sourceArray[index] == targetArray[index]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean equalCharOffsets(CharOffsets source, CharOffsets target) {
        byte[] targetArray;
        byte[] sourceArray = source.getArray();
        if (sourceArray.length == (targetArray = target.getArray()).length) {
            for (int index = 0; index < 7; ++index) {
                if (sourceArray[index] == targetArray[index]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private int addAndCopy(CharShape source) {
        CharShape target = this.docInfoAdder.getTargetHWPFile().getDocInfo().addNewCharShape();
        this.copyFaceNameIds(source.getFaceNameIds(), target.getFaceNameIds());
        this.copyRatios(source.getRatios(), target.getRatios());
        this.copyCharSpaces(source.getCharSpaces(), target.getCharSpaces());
        this.copyRelativeSizes(source.getRelativeSizes(), target.getRelativeSizes());
        this.copyCharOffsets(source.getCharOffsets(), target.getCharOffsets());
        target.setBaseSize(source.getBaseSize());
        target.getProperty().setValue(source.getProperty().getValue());
        target.setShadowGap1(source.getShadowGap1());
        target.setShadowGap2(source.getShadowGap2());
        target.getCharColor().setValue(source.getCharColor().getValue());
        target.getUnderLineColor().setValue(source.getUnderLineColor().getValue());
        target.getShadeColor().setValue(source.getShadeColor().getValue());
        target.getShadowColor().setValue(source.getShadowColor().getValue());
        if (source.getBorderFillId() == 0) {
            target.setBorderFillId(0);
        } else {
            target.setBorderFillId(this.docInfoAdder.forBorderFill().processById(source.getBorderFillId()));
        }
        target.getStrikeLineColor().setValue(source.getStrikeLineColor().getValue());
        return this.docInfoAdder.getTargetHWPFile().getDocInfo().getCharShapeList().size() - 1;
    }

    private void copyFaceNameIds(FaceNameIds source, FaceNameIds target) {
        target.setHangul(this.docInfoAdder.forFaceName().processByHangulId(source.getHangul()));
        target.setLatin(this.docInfoAdder.forFaceName().processByLatinId(source.getLatin()));
        target.setHanja(this.docInfoAdder.forFaceName().processByHanjaId(source.getHanja()));
        target.setJapanese(this.docInfoAdder.forFaceName().processByJapaneseId(source.getJapanese()));
        target.setOther(this.docInfoAdder.forFaceName().processByOtherId(source.getOther()));
        target.setSymbol(this.docInfoAdder.forFaceName().processBySymbolId(source.getSymbol()));
        target.setUser(this.docInfoAdder.forFaceName().processByUserId(source.getUser()));
    }

    private void copyRatios(Ratios source, Ratios target) {
        target.setHangul(source.getHangul());
        target.setLatin(source.getLatin());
        target.setHanja(source.getHanja());
        target.setJapanese(source.getJapanese());
        target.setOther(source.getOther());
        target.setSymbol(source.getSymbol());
        target.setUser(source.getUser());
    }

    private void copyCharSpaces(CharSpaces source, CharSpaces target) {
        target.setHangul(source.getHangul());
        target.setLatin(source.getLatin());
        target.setHanja(source.getHanja());
        target.setJapanese(source.getJapanese());
        target.setOther(source.getOther());
        target.setSymbol(source.getSymbol());
        target.setUser(source.getUser());
    }

    private void copyRelativeSizes(RelativeSizes source, RelativeSizes target) {
        target.setHangul(source.getHangul());
        target.setLatin(source.getLatin());
        target.setHanja(source.getHanja());
        target.setJapanese(source.getJapanese());
        target.setOther(source.getOther());
        target.setSymbol(source.getSymbol());
        target.setUser(source.getUser());
    }

    private void copyCharOffsets(CharOffsets source, CharOffsets target) {
        target.setHangul(source.getHangul());
        target.setLatin(source.getLatin());
        target.setHanja(source.getHanja());
        target.setJapanese(source.getJapanese());
        target.setOther(source.getOther());
        target.setSymbol(source.getSymbol());
        target.setUser(source.getUser());
    }

    public boolean equalById(int sourceId, int targetId) {
        CharShape target;
        CharShape source;
        try {
            source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getCharShapeList().get(sourceId - 1);
        }
        catch (Exception e) {
            source = null;
        }
        try {
            target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getCharShapeList().get(targetId - 1);
        }
        catch (Exception e) {
            target = null;
        }
        if (source == null && target == null) {
            return sourceId == targetId;
        }
        if (source == null || target == null) {
            return false;
        }
        return this.equal(source, target);
    }
}

