/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder.docinfo;

import java.util.HashMap;
import kr.dogfoot.hwplib.object.docinfo.ParaShape;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;

public class ParaShapeAdder {
    private DocInfoAdder docInfoAdder;
    private HashMap<Integer, Integer> idMatchingMap;

    public ParaShapeAdder(DocInfoAdder docInfoAdder) {
        this.docInfoAdder = docInfoAdder;
        this.idMatchingMap = new HashMap();
    }

    public int processById(int sourceId) {
        ParaShape source;
        if (this.docInfoAdder.getSourceHWPFile() == this.docInfoAdder.getTargetHWPFile()) {
            return sourceId;
        }
        if (this.idMatchingMap.containsKey(sourceId)) {
            return this.idMatchingMap.get(sourceId);
        }
        try {
            source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getParaShapeList().get(sourceId);
        }
        catch (Exception e) {
            return sourceId;
        }
        int id = this.findFromTarget(source);
        if (id == -1) {
            id = this.addAndCopy(source);
        }
        this.idMatchingMap.put(sourceId, id);
        return id;
    }

    private int findFromTarget(ParaShape source) {
        int count = this.docInfoAdder.getTargetHWPFile().getDocInfo().getParaShapeList().size();
        for (int index = 0; index < count; ++index) {
            ParaShape target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getParaShapeList().get(index);
            if (!this.equal(source, target)) continue;
            return index;
        }
        return -1;
    }

    private boolean equal(ParaShape source, ParaShape target) {
        return source.getProperty1().getValue() == target.getProperty1().getValue() && source.getLeftMargin() == target.getLeftMargin() && source.getRightMargin() == target.getRightMargin() && source.getIndent() == target.getIndent() && source.getTopParaSpace() == target.getTopParaSpace() && source.getBottomParaSpace() == target.getBottomParaSpace() && source.getLineSpace() == target.getLineSpace() && this.docInfoAdder.forTabDef().equalById(source.getTabDefId(), target.getTabDefId()) && this.equalParaHead(source, target) && this.docInfoAdder.forBorderFill().equalById(source.getBorderFillId(), target.getBorderFillId()) && source.getLeftBorderSpace() == target.getLeftBorderSpace() && source.getRightBorderSpace() == target.getRightBorderSpace() && source.getTopBorderSpace() == target.getTopBorderSpace() && source.getBottomBorderSpace() == target.getBottomBorderSpace() && source.getProperty2().getValue() == target.getProperty2().getValue() && source.getProperty3().getValue() == target.getProperty3().getValue() && source.getLineSpace2() == target.getLineSpace2() && source.getParaLevel() == target.getParaLevel();
    }

    private boolean equalParaHead(ParaShape source, ParaShape target) {
        if (source.getProperty1().getParaHeadShape() == target.getProperty1().getParaHeadShape()) {
            switch (source.getProperty1().getParaHeadShape()) {
                case None: {
                    return true;
                }
                case Numbering: 
                case Outline: {
                    if (source.getParaHeadId() > 0) {
                        return this.docInfoAdder.forNumbering().equalById(source.getParaHeadId(), target.getParaHeadId());
                    }
                    return false;
                }
                case Bullet: {
                    return this.docInfoAdder.forBullet().equalById(source.getParaHeadId(), target.getParaHeadId());
                }
            }
        }
        return false;
    }

    private int addAndCopy(ParaShape source) {
        ParaShape target = this.docInfoAdder.getTargetHWPFile().getDocInfo().addNewParaShape();
        target.getProperty1().setValue(source.getProperty1().getValue());
        target.setLeftMargin(source.getLeftMargin());
        target.setRightMargin(source.getRightMargin());
        target.setIndent(source.getIndent());
        target.setTopParaSpace(source.getTopParaSpace());
        target.setBottomParaSpace(source.getBottomParaSpace());
        target.setLineSpace(source.getLineSpace());
        target.setTabDefId(this.docInfoAdder.forTabDef().processById(source.getTabDefId()));
        this.setParaHead(source, target);
        target.setBorderFillId(this.docInfoAdder.forBorderFill().processById(source.getBorderFillId()));
        target.setLeftBorderSpace(source.getLeftBorderSpace());
        target.setRightBorderSpace(source.getRightBorderSpace());
        target.setTopBorderSpace(source.getTopBorderSpace());
        target.setBottomBorderSpace(source.getBottomBorderSpace());
        target.getProperty2().setValue(source.getProperty2().getValue());
        target.getProperty3().setValue(source.getProperty3().getValue());
        target.setLineSpace2(source.getLineSpace2());
        target.setParaLevel(source.getParaLevel());
        return this.docInfoAdder.getTargetHWPFile().getDocInfo().getParaShapeList().size() - 1;
    }

    private void setParaHead(ParaShape source, ParaShape target) {
        switch (source.getProperty1().getParaHeadShape()) {
            case None: {
                target.setParaHeadId(0);
                break;
            }
            case Numbering: 
            case Outline: {
                if (source.getParaHeadId() > 0) {
                    target.setParaHeadId(this.docInfoAdder.forNumbering().processById(source.getParaHeadId()));
                    break;
                }
                target.setParaHeadId(0);
                break;
            }
            case Bullet: {
                target.setParaHeadId(this.docInfoAdder.forBullet().processById(source.getParaHeadId()));
            }
        }
    }

    public boolean equalById(int sourceId, int targetId) {
        ParaShape source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getParaShapeList().get(sourceId);
        ParaShape target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getParaShapeList().get(targetId);
        return this.equal(source, target);
    }
}

