/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder.docinfo;

import java.util.ArrayList;
import java.util.HashMap;
import kr.dogfoot.hwplib.object.docinfo.TabDef;
import kr.dogfoot.hwplib.object.docinfo.tabdef.TabInfo;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;

public class TabDefAdder {
    private DocInfoAdder docInfoAdder;
    private HashMap<Integer, Integer> idMatchingMap;

    public TabDefAdder(DocInfoAdder docInfoAdder) {
        this.docInfoAdder = docInfoAdder;
        this.idMatchingMap = new HashMap();
    }

    public int processById(int sourceId) {
        TabDef source;
        if (this.docInfoAdder.getSourceHWPFile() == this.docInfoAdder.getTargetHWPFile()) {
            return sourceId;
        }
        if (this.idMatchingMap.containsKey(sourceId)) {
            return this.idMatchingMap.get(sourceId);
        }
        try {
            source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getTabDefList().get(sourceId);
        }
        catch (Exception e) {
            return sourceId;
        }
        int id = this.findFromTarget(source);
        if (id == -1) {
            id = this.addAndCopy(source);
        }
        this.idMatchingMap.put(sourceId, id);
        return id;
    }

    private int findFromTarget(TabDef source) {
        int count = this.docInfoAdder.getTargetHWPFile().getDocInfo().getTabDefList().size();
        for (int index = 0; index < count; ++index) {
            TabDef target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getTabDefList().get(index);
            if (!this.equal(source, target)) continue;
            return index;
        }
        return -1;
    }

    private boolean equal(TabDef source, TabDef target) {
        return source.getProperty().getValue() == target.getProperty().getValue() && this.equalTabInfoList(source.getTabInfoList(), target.getTabInfoList());
    }

    private boolean equalTabInfoList(ArrayList<TabInfo> source, ArrayList<TabInfo> target) {
        if (source.size() == target.size()) {
            int count = source.size();
            for (int index = 0; index < count; ++index) {
                if (this.equalTabInfo(source.get(index), target.get(index))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean equalTabInfo(TabInfo source, TabInfo target) {
        return source.getPosition() == target.getPosition() && source.getTabSort() == target.getTabSort() && source.getFillSort() == target.getFillSort();
    }

    private int addAndCopy(TabDef source) {
        TabDef target = this.docInfoAdder.getTargetHWPFile().getDocInfo().addNewTabDef();
        target.getProperty().setValue(source.getProperty().getValue());
        for (TabInfo sourceTabInfo : source.getTabInfoList()) {
            TabInfo targetTabInfo = target.addNewTabInfo();
            this.copyTabInfo(sourceTabInfo, targetTabInfo);
        }
        return this.docInfoAdder.getTargetHWPFile().getDocInfo().getTabDefList().size() - 1;
    }

    private void copyTabInfo(TabInfo source, TabInfo target) {
        target.setPosition(source.getPosition());
        target.setTabSort(source.getTabSort());
        target.setFillSort(source.getFillSort());
    }

    public boolean equalById(int sourceId, int targetId) {
        TabDef source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getTabDefList().get(sourceId);
        TabDef target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getTabDefList().get(targetId);
        return this.equal(source, target);
    }
}

