/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.textextractor;

import java.io.UnsupportedEncodingException;
import kr.dogfoot.hwplib.object.bodytext.ParagraphListInterface;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlArc;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlEllipse;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPolygon;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlRectangle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.gso.textbox.TextBox;
import kr.dogfoot.hwplib.tool.textextractor.ForParagraphList;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractMethod;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractOption;
import kr.dogfoot.hwplib.tool.textextractor.paraHead.ParaHeadMaker;

public class ForGso {
    public static void extract(GsoControl gc, TextExtractMethod tem, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForGso.extract(gc, new TextExtractOption(tem), paraHeadMaker, sb);
    }

    public static void extract(GsoControl gc, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        switch (gc.getGsoType()) {
            case Line: {
                break;
            }
            case Rectangle: {
                ForGso.rectangle((ControlRectangle)gc, option, paraHeadMaker, sb);
                break;
            }
            case Ellipse: {
                ForGso.ellipse((ControlEllipse)gc, option, paraHeadMaker, sb);
                break;
            }
            case Arc: {
                ForGso.arc((ControlArc)gc, option, paraHeadMaker, sb);
                break;
            }
            case Polygon: {
                ForGso.polygon((ControlPolygon)gc, option, paraHeadMaker, sb);
                break;
            }
            case Curve: {
                ForGso.curve((ControlCurve)gc, option, paraHeadMaker, sb);
                break;
            }
            case Picture: {
                break;
            }
            case OLE: {
                break;
            }
            case Container: {
                ForGso.container((ControlContainer)gc, option, paraHeadMaker, sb);
                break;
            }
        }
    }

    private static void rectangle(ControlRectangle rectangle, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForGso.textBox(rectangle.getTextBox(), option, paraHeadMaker, sb);
    }

    private static void textBox(TextBox textBox, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        if (textBox == null) {
            return;
        }
        ForParagraphList.extract((ParagraphListInterface)textBox.getParagraphList(), option, paraHeadMaker, sb);
    }

    private static void ellipse(ControlEllipse ellipse, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForGso.textBox(ellipse.getTextBox(), option, paraHeadMaker, sb);
    }

    private static void arc(ControlArc arc, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForGso.textBox(arc.getTextBox(), option, paraHeadMaker, sb);
    }

    private static void polygon(ControlPolygon polygon, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForGso.textBox(polygon.getTextBox(), option, paraHeadMaker, sb);
    }

    private static void curve(ControlCurve curve, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForGso.textBox(curve.getTextBox(), option, paraHeadMaker, sb);
    }

    private static void container(ControlContainer container, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        for (GsoControl child : container.getChildControlList()) {
            ForGso.extract(child, option, paraHeadMaker, sb);
        }
    }
}

