/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.textextractor;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharNormal;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.ParaText;
import kr.dogfoot.hwplib.tool.textextractor.ForControl;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractMethod;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractOption;
import kr.dogfoot.hwplib.tool.textextractor.paraHead.ParaHeadMaker;

public class ForParagraph {
    public static final int ParaStart = -1;
    public static final int ParaEnd = 65535;

    public static void extract(Paragraph p, int startIndex, TextExtractMethod tem, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraph.extract(p, startIndex, 65535, false, new TextExtractOption(tem), paraHeadMaker, sb);
    }

    public static void extract(Paragraph p, int startIndex, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraph.extract(p, startIndex, 65535, false, option, paraHeadMaker, sb);
    }

    public static void extract(Paragraph p, int startIndex, int endIndex, TextExtractMethod tem, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraph.extract(p, startIndex, endIndex, false, new TextExtractOption(tem), paraHeadMaker, sb);
    }

    public static void extract(Paragraph p, TextExtractMethod tem, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraph.extract(p, -1, 65535, false, new TextExtractOption(tem), paraHeadMaker, sb);
    }

    public static void extract(Paragraph p, int startIndex, int endIndex, boolean appendLF, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ArrayList<Control> controlList = new ArrayList<Control>();
        ParaText pt = p.getText();
        if (pt != null) {
            int controlIndex = 0;
            int charCount = pt.getCharList().size();
            block5: for (int charIndex = 0; charIndex < charCount; ++charIndex) {
                HWPChar ch = pt.getCharList().get(charIndex);
                switch (ch.getType()) {
                    case Normal: {
                        if (startIndex > charIndex || charIndex > endIndex) continue block5;
                        ForParagraph.normalText(ch, sb);
                        continue block5;
                    }
                    case ControlChar: 
                    case ControlInline: {
                        if (startIndex > charIndex || charIndex > endIndex || !option.isWithControlChar()) continue block5;
                        ForParagraph.controlText(ch, sb);
                        continue block5;
                    }
                    case ControlExtend: {
                        if (startIndex <= charIndex && charIndex <= endIndex) {
                            if (option.getMethod() == TextExtractMethod.InsertControlTextBetweenParagraphText) {
                                sb.append("\n");
                                ForControl.extract(p.getControlList().get(controlIndex), option, paraHeadMaker, sb);
                            } else {
                                controlList.add(p.getControlList().get(controlIndex));
                            }
                        }
                        ++controlIndex;
                        continue block5;
                    }
                }
            }
        }
        if (appendLF && option.isAppendEndingLF()) {
            sb.append("\n");
        }
        if (option.getMethod() == TextExtractMethod.AppendControlTextAfterParagraphText) {
            ForParagraph.controls(controlList, option, paraHeadMaker, sb);
        }
    }

    private static void normalText(HWPChar ch, StringBuffer sb) throws UnsupportedEncodingException {
        sb.append(((HWPCharNormal)ch).getCh());
    }

    private static void controlText(HWPChar ch, StringBuffer sb) {
        switch (ch.getCode()) {
            case 9: {
                sb.append("\t");
                break;
            }
            case 10: {
                sb.append("\n");
                break;
            }
            case 24: {
                sb.append("_");
            }
        }
    }

    private static void controls(ArrayList<Control> controlList, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        if (controlList != null) {
            for (Control c : controlList) {
                ForControl.extract(c, option, paraHeadMaker, sb);
            }
        }
    }
}

