/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.util.compoundFile.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DirectoryEntry;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentEntry;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentInputStream;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.Entry;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class CompoundFileReader {
    private POIFSFileSystem fs;
    private DirectoryEntry currentStorage;

    public CompoundFileReader(File file) throws IOException {
        this.fs = new POIFSFileSystem(new FileInputStream(file));
        this.currentStorage = this.fs.getRoot();
    }

    public CompoundFileReader(InputStream is) throws IOException {
        this.fs = new POIFSFileSystem(is);
        this.currentStorage = this.fs.getRoot();
    }

    public Set<String> listChildNames() {
        return this.currentStorage.getEntryNames();
    }

    public boolean isChildStorage(String name) throws FileNotFoundException {
        return this.currentStorage.hasEntry(name) && this.currentStorage.getEntry(name).isDirectoryEntry();
    }

    public boolean isChildStream(String name) throws FileNotFoundException {
        return this.currentStorage.hasEntry(name) && this.currentStorage.getEntry(name).isDocumentEntry();
    }

    public void moveChildStorage(String name) throws Exception {
        Entry e = this.currentStorage.getEntry(name);
        if (e == null || !e.isDirectoryEntry()) {
            throw new Exception("this is not storage.");
        }
        this.currentStorage = (DirectoryEntry)e;
    }

    public void moveParentStorage() {
        if (this.currentStorage != this.fs.getRoot()) {
            this.currentStorage = this.currentStorage.getParent();
        }
    }

    public StreamReader getChildStreamReader(String name, boolean compress, FileVersion fileVersion) throws Exception {
        Entry e = this.currentStorage.getEntry(name);
        if (e != null && e.isDocumentEntry()) {
            return StreamReader.create((DocumentEntry)e, compress, false, fileVersion);
        }
        throw new Exception("this is not stream.");
    }

    public StreamReader getChildStreamReaderForDistribution(String name, boolean compress, FileVersion fileVersion) throws Exception {
        Entry e = this.getCurrentStorage().getEntry(name);
        if (e != null && e.isDocumentEntry()) {
            return StreamReader.create((DocumentEntry)e, compress, true, fileVersion);
        }
        throw new Exception(name + " is not stream.");
    }

    public DocumentInputStream getChildInputStream(String name) throws Exception {
        Entry e = this.currentStorage.getEntry(name);
        if (e != null && e.isDocumentEntry()) {
            return new DocumentInputStream((DocumentEntry)e);
        }
        return null;
    }

    public void close() throws IOException {
        this.fs = null;
    }

    protected DirectoryEntry getCurrentStorage() {
        return this.currentStorage;
    }
}

