/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.util.compoundFile.reader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.SecretKeySpec;
import kr.dogfoot.hwplib.object.RecordHeader;
import kr.dogfoot.hwplib.object.docinfo.DocInfo;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentEntry;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentInputStream;
import kr.dogfoot.hwplib.util.binary.BitFlag;
import kr.dogfoot.hwplib.util.binary.Compressor;
import kr.dogfoot.hwplib.util.binary.Obfuscation;

public class StreamReader {
    protected InputStream is;
    protected long size = 0L;
    private long read = 0L;
    private RecordHeader header = new RecordHeader();
    private long readAfterHeader = 0L;
    protected FileVersion fileVersion;
    private DocInfo docInfo = null;

    public static StreamReader create(DocumentEntry de, boolean compress, boolean distribution, FileVersion fileVersion) throws Exception {
        InputStream is = StreamReader.documentInputStream(de, distribution);
        if (compress) {
            try {
                byte[] decompressed = Compressor.decompressedBytes(is);
                return new StreamReader().init(fileVersion, new ByteArrayInputStream(decompressed), decompressed.length);
            }
            catch (Exception e) {
                return new StreamReader().init(fileVersion, is, de.getSize());
            }
        }
        return new StreamReader().init(fileVersion, is, de.getSize());
    }

    private static InputStream documentInputStream(DocumentEntry de, boolean distribution) throws Exception {
        DocumentInputStream is = new DocumentInputStream(de);
        if (distribution) {
            return StreamReader.decryptStream(is);
        }
        return is;
    }

    private static InputStream decryptStream(InputStream is) throws Exception {
        Key secretKey = StreamReader.secretKey(is);
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, secretKey);
        return new CipherInputStream(is, cipher);
    }

    private static Key secretKey(InputStream is) throws IOException {
        byte[] distributionDocumentData = StreamReader.readDistributionDocData(is);
        int offset = 4 + (distributionDocumentData[0] & 0xF);
        byte[] keyBytes = Arrays.copyOfRange(distributionDocumentData, offset, offset + 16);
        return new SecretKeySpec(keyBytes, "AES");
    }

    private static byte[] readDistributionDocData(InputStream is) throws IOException {
        byte[] header = new byte[4];
        is.read(header, 0, 4);
        byte[] body = new byte[256];
        is.read(body, 0, 256);
        Obfuscation.transform(body);
        return body;
    }

    protected StreamReader() {
    }

    private StreamReader init(FileVersion fileVersion, InputStream is, int size) {
        this.fileVersion = fileVersion;
        this.is = is;
        this.size = size;
        return this;
    }

    public void readBytes(byte[] buffer) throws IOException {
        this.is.read(buffer);
        this.forwardPosition(buffer.length);
    }

    protected void forwardPosition(long n) {
        this.read += n;
        this.readAfterHeader += n;
    }

    public byte readSInt1() throws IOException {
        byte[] buffer = this.readBytes(1);
        return buffer[0];
    }

    private byte[] readBytes(int n) throws IOException {
        byte[] buffer = new byte[n];
        this.readBytes(buffer);
        return buffer;
    }

    public short readUInt1() throws IOException {
        byte[] buffer = this.readBytes(1);
        byte[] buffer2 = new byte[]{buffer[0], 0};
        return ByteBuffer.wrap(buffer2).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    public short readSInt2() throws IOException {
        byte[] buffer = this.readBytes(2);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    public int readUInt2() throws IOException {
        byte[] buffer = this.readBytes(2);
        byte[] buffer2 = new byte[]{buffer[0], buffer[1], 0, 0};
        return ByteBuffer.wrap(buffer2).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public int readSInt4() throws IOException {
        byte[] buffer = this.readBytes(4);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public long readUInt4() throws IOException {
        byte[] buffer = this.readBytes(4);
        byte[] buffer2 = new byte[]{buffer[0], buffer[1], buffer[2], buffer[3], 0, 0, 0, 0};
        return ByteBuffer.wrap(buffer2).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public double readDouble() throws IOException {
        byte[] buffer = this.readBytes(8);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    public float readFloat() throws IOException {
        byte[] buffer = this.readBytes(4);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public void skip(int n) throws IOException {
        this.readBytes(n);
    }

    public void close() throws IOException {
        this.is.close();
        this.is = null;
    }

    public RecordHeader readRecordHeader() throws IOException {
        if (this.isEndOfStream()) {
            this.header.setTagID((short)0);
            this.header.setLevel((short)0);
            this.header.setSize(0L);
        } else {
            long value = this.readUInt4();
            this.header.setTagID((short)BitFlag.get(value, 0, 9));
            this.header.setLevel((short)BitFlag.get(value, 10, 19));
            this.header.setSize((short)BitFlag.get(value, 20, 31));
            if (this.header.getSize() == 4095L) {
                this.header.setSize(this.readUInt4());
            }
        }
        this.readAfterHeader = 0L;
        return this.header;
    }

    public String readUTF16LEString() throws IOException {
        int len = this.readUInt2();
        if (len > 0) {
            byte[] arr = new byte[len * 2];
            this.readBytes(arr);
            return new String(arr, 0, arr.length, StandardCharsets.UTF_16LE);
        }
        return null;
    }

    public byte[] readHWPString() throws IOException {
        int len = this.readUInt2();
        if (len > 0) {
            byte[] arr = new byte[len * 2];
            this.readBytes(arr);
            return arr;
        }
        return null;
    }

    public byte[] readWChar() throws IOException {
        byte[] arr = new byte[2];
        this.readBytes(arr);
        return arr;
    }

    public long getSize() {
        return this.size;
    }

    public long getCurrentPosition() {
        return this.read;
    }

    public boolean isEndOfStream() {
        return this.read >= this.size;
    }

    public RecordHeader getCurrentRecordHeader() {
        return this.header;
    }

    public long getCurrentPositionAfterHeader() {
        return this.readAfterHeader;
    }

    public FileVersion getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(FileVersion fileVersion) {
        this.fileVersion = fileVersion;
    }

    public boolean isEndOfRecord() {
        return this.readAfterHeader >= this.header.getSize();
    }

    public boolean isImmediatelyAfterReadingHeader() {
        return this.readAfterHeader == 0L;
    }

    public void nextRecord() {
        this.readAfterHeader = -1L;
    }

    public void skipToEndRecord() throws IOException {
        long n = this.getCurrentRecordHeader().getSize() - this.getCurrentPositionAfterHeader();
        if (n > 0L) {
            this.skip((int)n);
        }
    }

    public void setDocInfo(DocInfo docInfo) {
        this.docInfo = docInfo;
    }

    public int correctParaShapeId(int oldParaShapeId) {
        if (this.docInfo != null) {
            return oldParaShapeId - this.docInfo.getIDMappings().getParaShapeCount() + this.docInfo.getParaShapeList().size();
        }
        return oldParaShapeId;
    }
}

