/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.util.compoundFile.writer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import kr.dogfoot.hwplib.object.docinfo.DocInfo;
import kr.dogfoot.hwplib.object.etc.HWPString;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.util.binary.BitFlag;
import kr.dogfoot.hwplib.util.binary.Compressor;

public class StreamWriter {
    private String name;
    protected boolean compress;
    private FileVersion version;
    protected ByteArrayOutputStream os;
    private int currentRecordLevel;
    private DocInfo docInfo;

    public StreamWriter(String name, boolean compress, FileVersion version) {
        this.name = name;
        this.compress = compress;
        this.version = version;
        this.os = new ByteArrayOutputStream();
        this.currentRecordLevel = 0;
        this.docInfo = null;
    }

    public void close() throws IOException {
        this.os.close();
    }

    public String getName() {
        return this.name;
    }

    public FileVersion getFileVersion() {
        return this.version;
    }

    public InputStream getDataStream() throws IOException {
        byte[] bytes = null;
        bytes = !this.compress ? this.os.toByteArray() : Compressor.compress(this.os.toByteArray());
        return new ByteArrayInputStream(bytes);
    }

    public void writeBytes(byte[] value) throws IOException {
        this.os.write(value);
    }

    public void writeBytes(byte[] value, int count) throws IOException {
        if (value.length == count) {
            this.os.write(value);
        } else if (value.length > count) {
            for (int i = 0; i < count; ++i) {
                this.os.write(value[i]);
            }
        } else if (value.length < count) {
            this.writeZero(count - value.length);
        }
    }

    public void writeSInt1(byte value) throws IOException {
        byte[] buffer = new byte[]{value};
        this.writeBytes(buffer);
    }

    public void writeSInt2(short value) throws IOException {
        byte[] buffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(value).array();
        this.writeBytes(buffer);
    }

    public void writeSInt4(int value) throws IOException {
        byte[] buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(value).array();
        this.writeBytes(buffer);
    }

    public void writeUInt1(short value) throws IOException {
        byte[] buffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(value).array();
        this.os.write(buffer, 0, 1);
    }

    public void writeUInt2(int value) throws IOException {
        byte[] buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(value).array();
        this.os.write(buffer, 0, 2);
    }

    public void writeUInt4(long value) throws IOException {
        byte[] buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(value).array();
        this.os.write(buffer, 0, 4);
    }

    public void writeDouble(double value) throws IOException {
        byte[] buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(value).array();
        this.os.write(buffer, 0, 8);
    }

    public void writeFloat(float value) throws IOException {
        byte[] buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(value).array();
        this.os.write(buffer, 0, 4);
    }

    public void writeRecordHeader(int tagID, long size) throws IOException {
        long header = 0L;
        header = BitFlag.set(header, 0, 9, tagID);
        header = BitFlag.set(header, 10, 19, this.currentRecordLevel);
        header = BitFlag.set(header, 20, 31, Math.min((int)size, 4095));
        this.writeUInt4(header);
        if (size >= 4095L) {
            this.writeUInt4(size);
        }
    }

    public void writeUTF16LEString(String value) throws IOException {
        if (value == null) {
            this.writeUInt2(0);
        } else {
            this.writeUInt2(value.length());
            if (value.length() > 0) {
                this.writeBytes(value.getBytes(StandardCharsets.UTF_16LE));
            }
        }
    }

    public void writeHWPString(HWPString value) throws IOException {
        if (value == null || value.getBytes() == null) {
            this.writeUInt2(0);
        } else {
            this.writeUInt2(value.getBytes().length / 2);
            if (value.getBytes().length > 0) {
                this.writeBytes(value.getBytes());
            }
        }
    }

    public void writeWChar(byte[] value) throws IOException {
        if (value != null && value.length >= 2) {
            this.os.write(value, 0, 2);
        } else {
            this.writeZero(2);
        }
    }

    public void writeZero(int number) throws IOException {
        if (number > 0) {
            byte[] zero = new byte[number];
            this.os.write(zero);
        }
    }

    public void upRecordLevel() {
        ++this.currentRecordLevel;
    }

    public void downRecordLevel() {
        --this.currentRecordLevel;
    }

    public void setDocInfo(DocInfo docInfo) {
        this.docInfo = docInfo;
    }

    public int correctParaShapeId(int oldParaShapeId) {
        if (this.docInfo != null) {
            return oldParaShapeId + this.docInfo.getIDMappings().getParaShapeCount() - this.docInfo.getParaShapeList().size();
        }
        return oldParaShapeId;
    }
}

