/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.autosetter;

import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.object.bodytext.paragraph.header.ControlMask;
import kr.dogfoot.hwplib.object.bodytext.paragraph.header.ParaHeader;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.ParaText;
import kr.dogfoot.hwplib.writer.autosetter.InstanceID;
import kr.dogfoot.hwplib.writer.autosetter.control.ForControl;

public class ForParagraph {
    public static void autoSet(Paragraph p, boolean lastInList, InstanceID iid) {
        ForParagraph.header(p, lastInList);
        ForParagraph.controls(p, iid);
    }

    private static void header(Paragraph p, boolean lastInList) {
        ParaHeader h = p.getHeader();
        h.setLastInList(lastInList);
        ForParagraph.setCharacterCount(h, p.getText());
        ForParagraph.setControlMask(h.getControlMask(), p.getText());
        if (p.getCharShape() != null) {
            h.setCharShapeCount(p.getCharShape().getPositonShapeIdPairList().size());
        } else {
            h.setCharShapeCount(0);
        }
        if (p.getRangeTag() != null) {
            h.setRangeTagCount(p.getRangeTag().getRangeTagItemList().size());
        } else {
            h.setRangeTagCount(0);
        }
        if (p.getLineSeg() != null) {
            h.setLineAlignCount(p.getLineSeg().getLineSegItemList().size());
        } else {
            h.setLineAlignCount(0);
        }
        h.setInstanceID(0L);
    }

    private static void setCharacterCount(ParaHeader h, ParaText t) {
        if (t != null) {
            int charCount = 0;
            for (HWPChar ch : t.getCharList()) {
                charCount += ch.getCharSize();
            }
            h.setCharacterCount(charCount);
        } else {
            h.setCharacterCount(1L);
        }
    }

    private static void setControlMask(ControlMask cm, ParaText t) {
        cm.setValue(0L);
        if (t == null) {
            return;
        }
        for (HWPChar ch : t.getCharList()) {
            switch (ch.getCode()) {
                case 2: {
                    cm.setHasSectColDef(true);
                    break;
                }
                case 3: {
                    cm.setHasFieldStart(true);
                    break;
                }
                case 4: {
                    cm.setHasFieldEnd(true);
                    break;
                }
                case 8: {
                    cm.setHasTitleMark(true);
                }
                case 9: {
                    cm.setHasTab(true);
                    break;
                }
                case 10: {
                    cm.setHasLineBreak(true);
                    break;
                }
                case 11: {
                    cm.setHasGsoTable(true);
                    break;
                }
                case 15: {
                    cm.setHasHiddenComment(true);
                    break;
                }
                case 16: {
                    cm.setHasHeaderFooter(true);
                    break;
                }
                case 17: {
                    cm.setHasFootnoteEndnote(true);
                    break;
                }
                case 18: {
                    cm.setHasAutoNumber(true);
                    break;
                }
                case 21: {
                    cm.setHasPageControl(true);
                    break;
                }
                case 22: {
                    cm.setHasBookmark(true);
                    break;
                }
                case 23: {
                    cm.setHasAdditionalTextOverlappingLetter(true);
                    break;
                }
                case 24: {
                    cm.setHasHyphen(true);
                    break;
                }
                case 30: {
                    cm.setHasBundleBlank(true);
                    break;
                }
                case 31: {
                    cm.setHasFixWidthBlank(true);
                }
            }
        }
    }

    private static void controls(Paragraph p, InstanceID iid) {
        if (p.getControlList() == null) {
            return;
        }
        for (Control c : p.getControlList()) {
            ForControl.autoSet(c, iid);
        }
    }
}

