/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.ControlColumnDefine;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderColumnDefine;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.columndefine.ColumnInfo;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.bookmark.ForCtrlData;

public class ForControlColumnDefine {
    public static void write(ControlColumnDefine cd, StreamWriter sw) throws IOException {
        ForControlColumnDefine.ctrlHeader(cd.getHeader(), sw);
        sw.upRecordLevel();
        ForCtrlData.write(cd.getCtrlData(), sw);
        sw.downRecordLevel();
    }

    private static void ctrlHeader(CtrlHeaderColumnDefine h, StreamWriter sw) throws IOException {
        ForControlColumnDefine.recordHeader(h, sw);
        sw.writeUInt4(h.getCtrlId());
        sw.writeUInt2(h.getProperty().getValue());
        short columnCount = h.getProperty().getColumnCount();
        boolean sameWidth = h.getProperty().isSameWidth();
        if (columnCount < 2 || sameWidth) {
            sw.writeUInt2(h.getGapBetweenColumn());
            sw.writeUInt2(h.getProperty2());
        } else {
            sw.writeUInt2(h.getProperty2());
            ForControlColumnDefine.columnInfos(h, sw);
        }
        sw.writeUInt1(h.getDivideLine().getType().getValue());
        sw.writeUInt1(h.getDivideLine().getThickness().getValue());
        sw.writeUInt4(h.getDivideLine().getColor().getValue());
    }

    private static void recordHeader(CtrlHeaderColumnDefine h, StreamWriter sw) throws IOException {
        sw.writeRecordHeader(71, ForControlColumnDefine.getSize(h));
    }

    private static int getSize(CtrlHeaderColumnDefine h) {
        int size = 0;
        size += 6;
        short columnCount = h.getProperty().getColumnCount();
        boolean sameWidth = h.getProperty().isSameWidth();
        size = columnCount < 2 || sameWidth ? (size += 4) : (size += 2 + columnCount * 4);
        return size += 6;
    }

    private static void columnInfos(CtrlHeaderColumnDefine h, StreamWriter sw) throws IOException {
        int count = h.getProperty().getColumnCount();
        for (int index = 0; index < count; ++index) {
            ColumnInfo ci = h.getColumnInfoList().get(index);
            sw.writeUInt2(ci.getWidth());
            sw.writeUInt2(ci.getGap());
        }
    }
}

