/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control.bookmark;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.ParameterItem;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.ParameterSet;
import kr.dogfoot.hwplib.util.StringUtil;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class ForParameterSet {
    public static int getSize(ParameterSet ps) {
        int size = 0;
        if (ps != null) {
            size += 6;
            for (ParameterItem pi : ps.getParameterItemList()) {
                size += ForParameterSet.getSizeForParameterItem(pi);
            }
        } else {
            size = 0;
        }
        return size;
    }

    private static int getSizeForParameterItem(ParameterItem pi) {
        int size = 0;
        size += 4;
        switch (pi.getType()) {
            case NULL: {
                break;
            }
            case String: {
                size += StringUtil.getUTF16LEStringSize(pi.getValue_BSTR());
                break;
            }
            case Integer1: {
                size += 4;
                break;
            }
            case Integer2: {
                size += 4;
                break;
            }
            case Integer4: {
                size += 4;
                break;
            }
            case Integer: {
                size += 4;
                break;
            }
            case UnsignedInteger1: {
                size += 4;
                break;
            }
            case UnsignedInteger2: {
                size += 4;
                break;
            }
            case UnsignedInteger4: {
                size += 4;
                break;
            }
            case UnsignedInteger: {
                size += 4;
                break;
            }
            case ParameterSet: {
                size += ForParameterSet.getSize(pi.getValue_ParameterSet());
                break;
            }
            case Array: {
                size += ForParameterSet.getSizeForParameterArray(pi);
                break;
            }
            case BINDataID: {
                size += 2;
            }
        }
        return size;
    }

    private static int getSizeForParameterArray(ParameterItem pi) {
        int size = 0;
        size += 4;
        int count = pi.getValue_ParameterArrayCount();
        for (int index = 0; index < count; ++index) {
            size += ForParameterSet.getSizeForParameterItem(pi.getValue_ParameterArray(index)) - 2;
        }
        return size;
    }

    public static void write(ParameterSet ps, StreamWriter sw) throws IOException {
        sw.writeUInt2(ps.getId());
        short parameterCount = (short)ps.getParameterItemList().size();
        sw.writeSInt2(parameterCount);
        sw.writeZero(2);
        for (ParameterItem pi : ps.getParameterItemList()) {
            ForParameterSet.parameterItem(pi, sw);
        }
    }

    private static void parameterItem(ParameterItem pi, StreamWriter sw) throws IOException {
        sw.writeUInt2((int)pi.getId());
        sw.writeUInt2(pi.getType().getValue());
        ForParameterSet.paramterValue(pi, sw);
    }

    private static void paramterValue(ParameterItem pi, StreamWriter sw) throws IOException {
        switch (pi.getType()) {
            case NULL: {
                break;
            }
            case String: {
                sw.writeUTF16LEString(pi.getValue_BSTR());
                break;
            }
            case Integer1: {
                sw.writeSInt4(pi.getValue_I1());
                break;
            }
            case Integer2: {
                sw.writeSInt4(pi.getValue_I2());
                break;
            }
            case Integer4: {
                sw.writeSInt4(pi.getValue_I4());
                break;
            }
            case Integer: {
                sw.writeSInt4(pi.getValue_I());
                break;
            }
            case UnsignedInteger1: {
                sw.writeUInt4(pi.getValue_UI1());
                break;
            }
            case UnsignedInteger2: {
                sw.writeUInt4(pi.getValue_UI2());
                break;
            }
            case UnsignedInteger4: {
                sw.writeUInt4(pi.getValue_UI4());
                break;
            }
            case UnsignedInteger: {
                sw.writeUInt4(pi.getValue_UI());
                break;
            }
            case ParameterSet: {
                ForParameterSet.write(pi.getValue_ParameterSet(), sw);
                break;
            }
            case Array: {
                ForParameterSet.parameterArray(pi, sw);
                break;
            }
            case BINDataID: {
                sw.writeUInt2(pi.getValue_binData());
            }
        }
    }

    private static void parameterArray(ParameterItem pi, StreamWriter sw) throws IOException {
        int count = pi.getValue_ParameterArrayCount();
        sw.writeSInt2((short)count);
        if (count > 0) {
            sw.writeUInt2((int)pi.getValue_ParameterArray(0).getId());
            for (int index = 0; index < count; ++index) {
                ParameterItem elementPi = pi.getValue_ParameterArray(index);
                sw.writeUInt2(elementPi.getType().getValue());
                ForParameterSet.paramterValue(elementPi, sw);
            }
        }
    }
}

