/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.curve.CurveSegmentType;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.polygon.PositionXY;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.part.ForTextBox;

public class ForControlCurve {
    public static void writeRest(ControlCurve curv, StreamWriter sw) throws Exception {
        sw.upRecordLevel();
        ForTextBox.write(curv.getTextBox(), sw);
        ForControlCurve.shapeComponentCurve(curv.getShapeComponentCurve(), sw);
        sw.downRecordLevel();
    }

    private static void shapeComponentCurve(ShapeComponentCurve scc, StreamWriter sw) throws IOException {
        ForControlCurve.recordHeader(scc, sw);
        int positionCount = scc.getPositionList().size();
        sw.writeSInt4(positionCount);
        for (PositionXY p : scc.getPositionList()) {
            sw.writeSInt4((int)p.getX());
            sw.writeSInt4((int)p.getY());
        }
        for (int index = 0; index < positionCount - 1; ++index) {
            CurveSegmentType cst = scc.getSegmentTypeList().get(index);
            sw.writeUInt1(cst.getValue());
        }
        sw.writeZero(4);
    }

    private static void recordHeader(ShapeComponentCurve scc, StreamWriter sw) throws IOException {
        sw.writeRecordHeader(83, ForControlCurve.getSize(scc));
    }

    private static int getSize(ShapeComponentCurve scc) {
        int size = 0;
        size += 4;
        size += scc.getPositionList().size() * 8;
        size += scc.getPositionList().size() - 1;
        return size += 4;
    }
}

