/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;

public class FluxClient {
    private final String endpoint;
    private int connectTimeoutMs = 15000;
    private int readTimeoutMs = 600000;

    public FluxClient(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setTimeouts(int connectMs, int readMs) {
        this.connectTimeoutMs = connectMs;
        this.readTimeoutMs = readMs;
    }

    public Path generateToFile(String prompt, String negativePrompt, int width, int height, Double guidance, Integer steps, Long seed, Path outPng) throws Exception {
        String escPrompt = FluxClient.escapeJson(prompt);
        if (width <= 0) {
            width = 1280;
        }
        if (height <= 0) {
            height = 720;
        }
        if (steps == null) {
            steps = 18;
        }
        if (guidance == null) {
            guidance = 3.5;
        }
        String payload = String.format("{\"prompt\":\"%s\",\"width\":%d,\"height\":%d,\"guidance_scale\":%.2f,\"num_inference_steps\":%d,\"seed\":%s}", escPrompt, width, height, guidance, steps == null ? 18 : steps, seed == null ? "null" : seed.toString());
        System.out.println("payload = " + payload);
        HttpURLConnection con = (HttpURLConnection)new URL(this.endpoint).openConnection();
        con.setConnectTimeout(this.connectTimeoutMs);
        con.setReadTimeout(this.readTimeoutMs);
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        Throwable throwable = null;
        Object var13_15 = null;
        try (OutputStream os = con.getOutputStream();){
            os.write(payload.getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int code = con.getResponseCode();
        InputStream is = code >= 200 && code < 300 ? con.getInputStream() : con.getErrorStream();
        String resp = new String(is.readAllBytes(), StandardCharsets.UTF_8);
        if (code < 200 || code >= 300) {
            throw new IOException("HTTP " + code + " : " + resp);
        }
        String b64 = FluxClient.extractJsonString(resp, "image_base64");
        if (b64 == null || b64.isBlank()) {
            throw new IOException("No image_base64 in response: " + resp);
        }
        byte[] png = Base64.getDecoder().decode(b64);
        Files.createDirectories(outPng.getParent(), new FileAttribute[0]);
        Files.write(outPng, png, new OpenOption[0]);
        return outPng;
    }

    private static String tryExtractDataUri(String json, String key) {
        String val = FluxClient.extractJsonString(json, key);
        if (val == null) {
            return null;
        }
        int comma = val.indexOf(",");
        if (val.startsWith("data:") && comma > 0) {
            return val.substring(comma + 1).trim();
        }
        return val;
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    private static String toJson(Object ... kv) {
        StringBuilder sb = new StringBuilder("{");
        int i = 0;
        while (i < kv.length) {
            if (i > 0) {
                sb.append(",");
            }
            String k = String.valueOf(kv[i]);
            Object v = kv[i + 1];
            sb.append("\"").append(FluxClient.esc(k)).append("\":");
            if (v == null) {
                sb.append("null");
            } else if (v instanceof Number || v instanceof Boolean) {
                sb.append(v.toString());
            } else {
                sb.append("\"").append(FluxClient.esc(String.valueOf(v))).append("\"");
            }
            i += 2;
        }
        return sb.append("}").toString();
    }

    private static String esc(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    if (c < ' ') {
                        sb.append(String.format("\\u%04x", c));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    private static String extractJsonString(String json, String key) {
        String pat = "\"" + key + "\"";
        int i = json.indexOf(pat);
        if (i < 0) {
            return null;
        }
        int colon = json.indexOf(58, i + pat.length());
        if (colon < 0) {
            return null;
        }
        int firstQuote = json.indexOf(34, colon + 1);
        if (firstQuote < 0) {
            return null;
        }
        int secondQuote = json.indexOf(34, firstQuote + 1);
        if (secondQuote < 0) {
            return null;
        }
        return json.substring(firstQuote + 1, secondQuote);
    }
}

