/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai;

import jakarta.inject.Inject;
import java.io.File;
import kr.co.goms.epub.ai.XhtmlMemoryService;
import kr.co.goms.epub.ai.XhtmlProjectIndexer;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IndexProjectXhtmlHandler {
    @Inject
    XhtmlMemoryService memory;

    @Execute
    public void run() {
        try {
            this.memory.initIfNeeded();
            File projectRoot = EpubPreferenceManager.getInstance().getProjectRoot();
            File textDir = new File(projectRoot, "OEBPS/Text");
            XhtmlProjectIndexer indexer = new XhtmlProjectIndexer(this.memory);
            StringBuilder report = new StringBuilder();
            indexer.indexAll(textDir, msg -> {
                System.out.println("[XHTML-Index] " + msg);
                report.append((String)msg).append("\n");
            });
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"XHTML \ud559\uc2b5(\uc0c9\uc778)", (String)("\uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n\n" + report.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"XHTML \ud559\uc2b5(\uc0c9\uc778) \uc624\ub958", (String)e.getMessage());
        }
    }
}

