/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;

public class OllamaClient {
    private static final HttpClient HTTP = HttpClient.newHttpClient();
    private static final String OLLAMA = "http://localhost:11434";

    public static float[] embedding(String model, String input) throws Exception {
        String body = "{\n  \"model\": \"%s\",\n  \"input\": %s\n}\n".formatted(model, OllamaClient.jsonQuote(input));
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("http://localhost:11434/api/embeddings")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).build();
        HttpResponse<String> res = HTTP.send(req, HttpResponse.BodyHandlers.ofString());
        if (res.statusCode() / 100 != 2) {
            throw new RuntimeException("Embeddings HTTP " + res.statusCode() + " : " + res.body());
        }
        JsonObject obj = JsonParser.parseString((String)res.body()).getAsJsonObject();
        JsonArray arr = obj.getAsJsonArray("embedding");
        if (arr == null) {
            throw new RuntimeException("Missing 'embedding' field in response: " + res.body());
        }
        float[] vec = new float[arr.size()];
        int i = 0;
        while (i < arr.size()) {
            vec[i] = arr.get(i).getAsFloat();
            ++i;
        }
        return OllamaClient.normalize(vec);
    }

    private static String jsonQuote(String s) {
        return "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n") + "\"";
    }

    private static float[] normalize(float[] v) {
        double sum = 0.0;
        float[] fArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            float x = fArray[n2];
            sum += (double)(x * x);
            ++n2;
        }
        double n3 = Math.sqrt(sum);
        if (n3 == 0.0) {
            return v;
        }
        float[] out = new float[v.length];
        int i = 0;
        while (i < v.length) {
            out[i] = (float)((double)v[i] / n3);
            ++i;
        }
        return out;
    }
}

