/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class OllamaFluxClient {
    private final String endpoint;
    private final String model;

    public OllamaFluxClient(String endpoint, String model) {
        this.endpoint = endpoint;
        this.model = model;
    }

    public Path generateImage(String prompt, String style, String size, Long seed, Path outDir, String baseName) throws Exception {
        OutputStream os22;
        Files.createDirectories(outDir, new FileAttribute[0]);
        String merged = style == null || style.isBlank() ? prompt : prompt + "\n\nStyle:\n" + style;
        String payload = this.toJson(Map.of("model", this.model, "prompt", merged, "size", size == null || size.isBlank() ? "1280x720" : size, "seed", seed == null ? 0L : seed));
        HttpURLConnection con = (HttpURLConnection)new URL(this.endpoint).openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.setRequestProperty("Content-Type", "application/json");
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            os22 = con.getOutputStream();
            try {
                os22.write(payload.getBytes());
            }
            finally {
                if (os22 != null) {
                    os22.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        ArrayList<String> image64List = new ArrayList<String>();
        throwable2 = null;
        os22 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.contains("\"images\"")) continue;
                int start = line.indexOf("[");
                int end = line.lastIndexOf("]");
                if (start <= 0 || end <= start) continue;
                String inside = line.substring(start + 1, end).trim();
                String[] stringArray = inside.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    String val = token.trim();
                    if (val.startsWith("\"") && val.endsWith("\"")) {
                        val = val.substring(1, val.length() - 1);
                        image64List.add(val);
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable os22) {
            if (throwable2 == null) {
                throwable2 = os22;
            } else if (throwable2 != os22) {
                throwable2.addSuppressed(os22);
            }
            throw throwable2;
        }
        if (image64List.isEmpty()) {
            throw new IOException("No images received from Ollama/Flux.");
        }
        byte[] bytes = Base64.getDecoder().decode((String)image64List.get(0));
        Path out = outDir.resolve(baseName + ".png");
        Files.write(out, bytes, new OpenOption[0]);
        return out;
    }

    private String toJson(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"").append(this.escape(e.getKey())).append("\":");
            Object v = e.getValue();
            if (v instanceof Number || v instanceof Boolean) {
                sb.append(v.toString());
                continue;
            }
            sb.append("\"").append(this.escape(String.valueOf(v))).append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

