/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai;

import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import kr.co.goms.epub.ai.XhtmlMemoryService;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class XhtmlProjectIndexer {
    private final XhtmlMemoryService memory;

    public XhtmlProjectIndexer(XhtmlMemoryService memory) {
        this.memory = memory;
    }

    public void indexAll(File textDir, Consumer<String> log) {
        if (textDir == null || !textDir.isDirectory()) {
            log.accept("Text \ub514\ub809\ud130\ub9ac\ub97c \ucc3e\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4: " + String.valueOf(textDir));
            return;
        }
        File[] files = textDir.listFiles((d, n) -> n.toLowerCase(Locale.ROOT).endsWith(".xhtml"));
        if (files == null || files.length == 0) {
            log.accept("XHTML \ud30c\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4: " + String.valueOf(textDir));
            return;
        }
        int ok = 0;
        int fail = 0;
        File[] fileArray = files;
        int n2 = files.length;
        int n3 = 0;
        while (n3 < n2) {
            File f = fileArray[n3];
            try {
                this.indexOneFile(f, log);
                ++ok;
            }
            catch (Exception e) {
                ++fail;
                log.accept("\uc778\ub371\uc2f1 \uc2e4\ud328: " + f.getName() + " - " + e.getMessage());
            }
            ++n3;
        }
        log.accept("\uc778\ub371\uc2f1 \uc644\ub8cc. \uc131\uacf5 " + ok + "\uac1c, \uc2e4\ud328 " + fail + "\uac1c");
    }

    public void indexOneFile(File file, Consumer<String> log) throws Exception {
        String txt;
        String id;
        Object txt2;
        String lower;
        String relPath = "OEBPS/Text/" + file.getName();
        String sha1 = XhtmlProjectIndexer.sha1OfFile(file);
        String prev = this.memory.getStoredSha1(relPath);
        if (prev != null && prev.equalsIgnoreCase(sha1)) {
            log.accept("\ubcc0\uacbd \uc5c6\uc74c(\uc2a4\ud0b5): " + file.getName());
            return;
        }
        if (prev != null && !prev.equalsIgnoreCase(sha1)) {
            this.memory.deleteSnippetsByFile(relPath);
            log.accept("\ubcc0\uacbd \uac10\uc9c0 \u2192 \uae30\uc874 \uc2a4\ub2c8\ud3ab \uc0ad\uc81c: " + file.getName());
        }
        if ((lower = file.getName().toLowerCase(Locale.ROOT)).equals("cover.xhtml")) {
            log.accept("\uac74\ub108\ub700(cover): " + file.getName());
            this.memory.upsertFileSha1(relPath, sha1);
            return;
        }
        Document doc = Jsoup.parse((File)file, (String)"UTF-8");
        doc.outputSettings().charset(StandardCharsets.UTF_8);
        int h = 1;
        while (h <= 6) {
            for (Element e : doc.select("h" + h)) {
                String id2 = e.hasAttr("id") ? e.attr("id") : null;
                txt2 = XhtmlProjectIndexer.safeText(e);
                this.addSnippetMaybe((String)txt2, relPath, id2, log);
            }
            ++h;
        }
        for (Element p : doc.select("p")) {
            id = p.hasAttr("id") ? p.attr("id") : null;
            txt = XhtmlProjectIndexer.safeText(p);
            this.addSnippetMaybe(txt, relPath, id, log);
        }
        for (Element img : doc.select("img")) {
            String alt;
            id = img.hasAttr("id") ? img.attr("id") : null;
            String string = alt = img.hasAttr("alt") ? img.attr("alt") : "";
            if (alt.isBlank() && id == null) continue;
            String caption = XhtmlProjectIndexer.findNearbyFigcaption(img);
            String txt3 = "[\uc774\ubbf8\uc9c0] " + (alt.isBlank() ? "(alt \uc5c6\uc74c)" : alt) + (String)(caption != null ? " | \ucea1\uc158: " + caption : "");
            this.addSnippetMaybe(txt3, relPath, id, log);
        }
        for (Element t : doc.select("table")) {
            id = t.hasAttr("id") ? t.attr("id") : null;
            String cap = Optional.ofNullable(t.selectFirst("caption")).map(Element::text).orElse("");
            txt2 = "[\ud45c] " + (cap.isBlank() ? (id != null ? id : "(\uc81c\ubaa9\uc5c6\uc74c)") : cap);
            this.addSnippetMaybe((String)txt2, relPath, id, log);
        }
        for (Element pre : doc.select("pre")) {
            id = pre.hasAttr("id") ? pre.attr("id") : null;
            txt = XhtmlProjectIndexer.trimLength("[\ucf54\ub4dc] " + pre.text(), 800);
            this.addSnippetMaybe(txt, relPath, id, log);
        }
        for (Element code : doc.select("code")) {
            if (code.parents().select("pre").size() > 0) continue;
            id = code.hasAttr("id") ? code.attr("id") : null;
            txt = XhtmlProjectIndexer.trimLength("[\ucf54\ub4dc] " + code.text(), 400);
            this.addSnippetMaybe(txt, relPath, id, log);
        }
        for (Element li : doc.select("li")) {
            id = li.hasAttr("id") ? li.attr("id") : null;
            txt = XhtmlProjectIndexer.safeText(li);
            if (txt.length() < 8) continue;
            this.addSnippetMaybe(txt, relPath, id, log);
        }
        this.memory.upsertFileSha1(relPath, sha1);
        log.accept("\uc0c9\uc778 \uc644\ub8cc: " + file.getName());
    }

    private static String sha1OfFile(File f) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream is = new FileInputStream(f);){
            int n;
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] buf = new byte[8192];
            while ((n = is.read(buf)) > 0) {
                md.update(buf, 0, n);
            }
            byte[] dig = md.digest();
            StringBuilder sb = new StringBuilder();
            byte[] byArray = dig;
            int n2 = dig.length;
            int n3 = 0;
            while (n3 < n2) {
                byte b = byArray[n3];
                sb.append(String.format("%02x", b));
                ++n3;
            }
            return sb.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String safeText(Element e) {
        String aria;
        String t = e.text();
        if (t == null) {
            t = "";
        }
        if ((t = t.replaceAll("\\s+", " ").trim()).isBlank() && !(aria = e.attr("aria-label")).isBlank()) {
            t = aria;
        }
        return XhtmlProjectIndexer.trimLength(t, 800);
    }

    private static String trimLength(String s, int max) {
        if (s == null) {
            return "";
        }
        return s.length() > max ? s.substring(0, max) + " \u2026" : s;
    }

    private static String optId(Element e, String prefix) {
        if (e.hasAttr("id")) {
            return e.attr("id");
        }
        return null;
    }

    private static String findNearbyFigcaption(Element img) {
        Element cap;
        Element fig = img.closest("figure");
        if (fig != null && (cap = fig.selectFirst("figcaption")) != null) {
            return cap.text();
        }
        return null;
    }

    private void addSnippetMaybe(String text, String relPath, String anchor, Consumer<String> log) {
        try {
            if (text == null || text.isBlank()) {
                return;
            }
            this.memory.addSnippet(text, relPath, anchor);
        }
        catch (Exception ex) {
            log.accept("\ucd94\uac00 \uc2e4\ud328: " + relPath + "#" + String.valueOf(anchor) + " - " + ex.getMessage());
        }
    }
}

