/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai.imagefx;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kr.co.goms.epub.ai.imagefx.AccountError;
import kr.co.goms.epub.ai.imagefx.Constants;
import kr.co.goms.epub.ai.imagefx.SessionData;
import kr.co.goms.epub.ai.imagefx.User;

public class Account {
    public User user;
    public String token;
    private Date tokenExpiry;
    private final String cookie;
    private final HttpClient http = HttpClient.newHttpClient();
    private final Gson gson = new Gson();

    public Account(String cookie) {
        if (cookie == null || cookie.trim().isEmpty()) {
            throw new AccountError("Cookie is required and cannot be empty");
        }
        this.cookie = cookie;
    }

    public void refreshSession() {
        SessionData sessionResult = this.fetchSession();
        if (sessionResult == null || sessionResult.access_token == null || sessionResult.expires == null || sessionResult.user == null) {
            throw new AccountError("Session response is missing some fields: \n" + this.gson.toJson((Object)sessionResult));
        }
        this.user = sessionResult.user;
        this.token = sessionResult.access_token;
        this.tokenExpiry = Account.parseExpiry(sessionResult.expires);
        System.out.println("================== refreshSession\uc744 \uc2e4\ud589\ud569\ub2c8\ub2e4 ================== ");
        System.out.println("SessionData user : " + String.valueOf(this.user));
        System.out.println("SessionData token : " + this.token);
        System.out.println("SessionData tokenExpiry : " + String.valueOf(this.tokenExpiry));
    }

    public boolean isTokenExpired() {
        if (this.token == null || this.tokenExpiry == null) {
            return true;
        }
        long nowMinus30s = System.currentTimeMillis() - 30000L;
        return this.tokenExpiry.getTime() <= nowMinus30s;
    }

    public Map<String, String> getAuthHeaders() {
        if (this.token == null) {
            throw new AccountError("Cookie or Token is still missing after refresh");
        }
        HashMap<String, String> headers = new HashMap<String, String>(Constants.DEFAULT_HEADERS);
        headers.put("Cookie", this.cookie);
        headers.put("Authorization", "Bearer " + this.token);
        return headers;
    }

    private SessionData fetchSession() {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create("https://labs.google/fx/api/auth/session")).GET();
            for (Map.Entry<String, String> e : Constants.DEFAULT_HEADERS.entrySet()) {
                builder.header(e.getKey(), e.getValue());
            }
            builder.header("Cookie", this.cookie);
            HttpRequest req = builder.build();
            HttpResponse<String> res = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() / 100 != 2) {
                String body = res.body() == null ? "" : res.body();
                throw new AccountError("Authentication failed (" + res.statusCode() + "): " + body);
            }
            SessionData data = (SessionData)this.gson.fromJson(res.body(), SessionData.class);
            if (data == null || data.access_token == null || data.expires == null || data.user == null) {
                throw new AccountError("Invalid session response: missing required fields");
            }
            return data;
        }
        catch (JsonSyntaxException e) {
            throw new AccountError("Invalid JSON in session response: " + e.getMessage());
        }
        catch (AccountError e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccountError("Failed to fetch session: " + e.getMessage());
        }
    }

    private static Date parseExpiry(String iso) {
        try {
            Instant instant = OffsetDateTime.parse(iso).toInstant();
            return Date.from(instant);
        }
        catch (Exception exception) {
            try {
                long epochMillis = Long.parseLong(iso);
                return new Date(epochMillis);
            }
            catch (NumberFormatException numberFormatException) {
                return Date.from(Instant.now().plusSeconds(60L));
            }
        }
    }
}

