/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai.imagefx;

import java.net.http.HttpRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Constants {
    public static final Map<String, String> DEFAULT_HEADERS;

    static {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Origin", "https://labs.google");
        headers.put("content-type", "application/json");
        headers.put("Referer", "https://labs.google/fx/tools/image-fx");
        DEFAULT_HEADERS = Collections.unmodifiableMap(headers);
    }

    private Constants() {
    }

    public static void applyDefaultHeaders(HttpRequest.Builder builder) {
        DEFAULT_HEADERS.forEach(builder::header);
    }

    public static enum AspectRatio {
        SQUARE("IMAGE_ASPECT_RATIO_SQUARE"),
        PORTRAIT("IMAGE_ASPECT_RATIO_PORTRAIT"),
        LANDSCAPE("IMAGE_ASPECT_RATIO_LANDSCAPE"),
        UNSPECIFIED("IMAGE_ASPECT_RATIO_UNSPECIFIED");

        private final String value;

        private AspectRatio(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static AspectRatio fromValue(String text) {
            AspectRatio[] aspectRatioArray = AspectRatio.values();
            int n = aspectRatioArray.length;
            int n2 = 0;
            while (n2 < n) {
                AspectRatio r = aspectRatioArray[n2];
                if (r.getValue().equalsIgnoreCase(text) || r.name().equalsIgnoreCase(text)) {
                    return r;
                }
                ++n2;
            }
            return LANDSCAPE;
        }
    }

    public static enum ImageType {
        JPEG("jpeg"),
        JPG("jpg"),
        JPE("jpe"),
        PNG("png"),
        GIF("gif"),
        WEBP("webp"),
        SVG("svg"),
        BMP("bmp"),
        TIFF("tiff"),
        APNG("apng"),
        AVIF("avif");

        private final String value;

        private ImageType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Model {
        IMAGEN_3("IMAGEN_3"),
        IMAGEN_3_1("IMAGEN_3_1"),
        IMAGEN_3_5("IMAGEN_3_5");

        private final String value;

        private Model(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PromptStyle {
        FLAT_VECTOR_ILLUSTRATION("flat vector illustration of cultural and historical landmarks, ancient statues and traditional architecture, inspired by East Asian art. clean geometric shapes, minimal shading, warm earthy color palette, balanced composition, \r\nand clear outlines. detailed but stylized illustration, professional tourism poster style, high contrast, modern flat design, no text, no icon, no numbers, no chart, no watermark, plain white background."),
        HYBRID_KOREA_INK_WASH("hybrid Korean ink wash and pastel cinematic realism style, \r\nsubtle ink textures, delicate paper grain, \r\nlow-saturation blue-grey and warm beige palette, \r\nsoft moonlight reflecting on the water, \r\npeaceful and introspective atmosphere, \r\nno text, 16:9 composition, 4K, ethereal lighting, meditative tone. no text, no icon, no numbers, no chart"),
        MINIMAL_PASTEL_ILLUSTRATION("minimalist pastel color illustration, soft gradients and simple shapes, clean background, gentle lighting, modern design aesthetic, emphasizing calm and warmth, professional editorial illustration style, no text, no watermark, plain background."),
        CINEMATIC_REALISM("cinematic realism with dramatic lighting and depth of field, high contrast, detailed textures, volumetric atmosphere, soft bokeh background, emotional and story-driven composition, 4K resolution, no text, no chart, no watermark."),
        TRADITIONAL_INK_BRUSH("traditional East Asian ink brush painting style, expressive brush strokes, natural flow of ink, rice paper texture, black and grey gradients, serene and contemplative mood, no text, no icon, no watermark, clean white background."),
        SILVER_TOWN_BRUSH("A gentle, warm Korean-style illustration for an essay book cover. Use pastel tones, warm neutrals, and a clean, minimal composition. Artwork style: gentle Korean picture-book aesthetic, soft textures, emotional warmth, subtle details. No text. No typography.");

        private final String value;

        private PromptStyle(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

