/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai.imagefx;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import kr.co.goms.epub.ai.imagefx.Constants;
import kr.co.goms.epub.ai.imagefx.ImageArg;
import kr.co.goms.epub.ai.imagefx.ImageError;

public class Image {
    private final long seed;
    private final Constants.Model model;
    private final String prompt;
    private final Constants.AspectRatio aspectRatio;
    private final String mediaId;
    private final String encodedImage;
    private final String workflowId;
    private final String fingerprintId;

    public Image(ImageArg args) {
        if (args.encodedImage == null || args.encodedImage.trim().isEmpty()) {
            throw new ImageError("Encoded image data is required");
        }
        this.seed = args.seed;
        this.prompt = args.prompt;
        this.model = args.modelNameType;
        this.aspectRatio = args.aspectRatio;
        this.workflowId = args.workflowId;
        this.encodedImage = args.encodedImage;
        this.mediaId = args.mediaGenerationId;
        this.fingerprintId = args.fingerprintLogRecordId;
    }

    public Path save(String dirPath) {
        if (dirPath == null || dirPath.trim().isEmpty()) {
            dirPath = ".";
        }
        Path directory = Paths.get(dirPath, new String[0]);
        Path outputFile = directory.resolve("image-" + System.currentTimeMillis() + ".png");
        try {
            if (Files.notExists(directory, new LinkOption[0])) {
                System.out.println("[*] Creating destination dir: " + dirPath);
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            byte[] imageBytes = Base64.getDecoder().decode(this.encodedImage);
            Files.write(outputFile, imageBytes, new OpenOption[0]);
            return outputFile;
        }
        catch (IOException e) {
            throw new ImageError("Failed to save image: " + e.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ImageError("Invalid Base64 image data");
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public Constants.Model getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Constants.AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getFingerprintId() {
        return this.fingerprintId;
    }
}

