/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai.imagefx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kr.co.goms.epub.ai.imagefx.Account;
import kr.co.goms.epub.ai.imagefx.Constants;
import kr.co.goms.epub.ai.imagefx.Image;
import kr.co.goms.epub.ai.imagefx.ImageArg;
import kr.co.goms.epub.ai.imagefx.ImageFXError;
import kr.co.goms.epub.ai.imagefx.Prompt;
import kr.co.goms.epub.ai.imagefx.PromptArg;

public class ImageFX {
    private final Account account;
    private final HttpClient http = HttpClient.newHttpClient();
    private final Gson gson = new GsonBuilder().create();

    public ImageFX(String cookie) {
        if (cookie == null || cookie.trim().isEmpty()) {
            throw new ImageFXError("Cookie is required and cannot be empty");
        }
        this.account = new Account(cookie);
    }

    public List<Image> generateImage(String prompt, int retries) {
        if (prompt == null || prompt.trim().isEmpty()) {
            throw new ImageFXError("Prompt cannot be empty");
        }
        return this.generateImage(new Prompt(ImageFX.buildPromptArg(prompt)), retries);
    }

    public List<Image> generateImage(Prompt prompt, int retries) {
        if (prompt == null) {
            throw new ImageFXError("Provided prompt is null");
        }
        this.account.refreshSession();
        List<ImageArg> args = this.fetchImages(prompt, retries);
        ArrayList<Image> images = new ArrayList<Image>(args.size());
        for (ImageArg a : args) {
            images.add(new Image(a));
        }
        return images;
    }

    public Image getImageFromId(String id) {
        if (id == null || id.trim().isEmpty()) {
            throw new ImageFXError("Image ID is required and cannot be empty");
        }
        this.account.refreshSession();
        String url = "https://labs.google/fx/api/trpc/media.fetchMedia";
        String payloadJson = this.gson.toJson(Map.of("json", Map.of("mediaKey", id)));
        String input = URLEncoder.encode(payloadJson, StandardCharsets.UTF_8);
        HttpRequest.Builder b = HttpRequest.newBuilder().uri(URI.create(url + "?input=" + input)).GET();
        ImageFX.applyAuthHeaders(b, this.account.getAuthHeaders());
        try {
            HttpResponse<String> res = this.http.send(b.build(), HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() / 100 != 2) {
                throw new ImageFXError("Server responded with unexpected response (" + res.statusCode() + "): " + res.body());
            }
            JsonObject root = JsonParser.parseString((String)res.body()).getAsJsonObject();
            JsonElement imageEl = ImageFX.deepGet(root, "result", "data", "json", "result", "image");
            if (imageEl == null || !imageEl.isJsonObject()) {
                throw new ImageFXError("Server responded with empty image");
            }
            ImageArg arg = (ImageArg)this.gson.fromJson(imageEl, ImageArg.class);
            return new Image(arg);
        }
        catch (IOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ImageFXError("Failed to fetch image: " + e.getMessage());
        }
        catch (ImageFXError e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImageFXError("Failed to fetch image: " + e.getMessage());
        }
    }

    public List<String> generateCaptionsFromImage(String imagePath, Constants.ImageType imageType, int count) {
        Object base64;
        if (imagePath == null || imagePath.isBlank() || !Files.exists(Path.of(imagePath, new String[0]), new LinkOption[0])) {
            throw new ImageFXError("Image doesn't exist at path: " + imagePath);
        }
        try {
            byte[] bytes = Files.readAllBytes(Path.of(imagePath, new String[0]));
            base64 = Base64.getEncoder().encodeToString(bytes);
            base64 = "data:image/" + imageType.getValue() + ";base64," + (String)base64;
        }
        catch (IOException e) {
            throw new ImageFXError("Failed to fetch image: " + e.getMessage());
        }
        this.account.refreshSession();
        String url = "https://labs.google/fx/api/trpc/backbone.captionImage";
        Map<String, Map<String, Map<String, Map<String, Object>>>> body = Map.of("json", Map.of("clientContext", Map.of("sessionId", ";1758297717089", "workflowId", ""), "captionInput", Map.of("candidatesCount", count, "mediaInput", Map.of("mediaCategory", "MEDIA_CATEGORY_SUBJECT", "rawBytes", base64))));
        HttpRequest.Builder b = HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(body)));
        ImageFX.applyAuthHeaders(b, this.account.getAuthHeaders());
        try {
            HttpResponse<String> res = this.http.send(b.build(), HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() / 100 != 2) {
                throw new ImageFXError("Server responded with unexpected response (" + res.statusCode() + "): " + res.body());
            }
            JsonObject root = JsonParser.parseString((String)res.body()).getAsJsonObject();
            JsonElement candidatesEl = ImageFX.deepGet(root, "result", "data", "json", "result", "candidates");
            if (candidatesEl == null || !candidatesEl.isJsonArray()) {
                throw new ImageFXError("Image caption was not in the response: " + res.body());
            }
            ArrayList<String> outputs = new ArrayList<String>();
            for (JsonElement el : candidatesEl.getAsJsonArray()) {
                JsonObject obj;
                JsonElement out;
                if (!el.isJsonObject() || (out = (obj = el.getAsJsonObject()).get("output")) == null || out.isJsonNull()) continue;
                outputs.add(out.getAsString());
            }
            return outputs;
        }
        catch (IOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ImageFXError("Failed to fetch image: " + e.getMessage());
        }
        catch (ImageFXError e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImageFXError("Failed to fetch image: " + e.getMessage());
        }
    }

    private List<ImageArg> fetchImages(Prompt prompt, int retry) {
        String url = "https://aisandbox-pa.googleapis.com/v1:runImageFx";
        HttpRequest.Builder b = HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofString(prompt.toString()));
        ImageFX.applyAuthHeaders(b, this.account.getAuthHeaders());
        try {
            HttpResponse<String> res = this.http.send(b.build(), HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() / 100 != 2) {
                if (retry > 0) {
                    System.out.println("[!] Failed to generate image. Retrying...");
                    return this.fetchImages(prompt, retry - 1);
                }
                throw new ImageFXError("Server responded with invalid response (" + res.statusCode() + "): " + res.body());
            }
            JsonObject root = JsonParser.parseString((String)res.body()).getAsJsonObject();
            JsonElement panelsEl = root.get("imagePanels");
            if (panelsEl == null || !panelsEl.isJsonArray() || panelsEl.getAsJsonArray().size() == 0) {
                throw new ImageFXError("Server responded with empty images");
            }
            JsonObject firstPanel = panelsEl.getAsJsonArray().get(0).getAsJsonObject();
            JsonElement genEl = firstPanel.get("generatedImages");
            if (genEl == null || !genEl.isJsonArray()) {
                throw new ImageFXError("Server responded with empty images");
            }
            ImageArg[] arr = (ImageArg[])this.gson.fromJson(genEl, ImageArg[].class);
            return Arrays.asList(arr);
        }
        catch (IOException | InterruptedException e) {
            if (retry > 0) {
                System.out.println("[!] Failed to generate image. Retrying...");
                return this.fetchImages(prompt, retry - 1);
            }
            Thread.currentThread().interrupt();
            throw new ImageFXError("Failed to generate image: " + e.getMessage());
        }
        catch (ImageFXError e) {
            if (retry > 0) {
                System.out.println("[!] Failed to generate image. Retrying...");
                return this.fetchImages(prompt, retry - 1);
            }
            throw e;
        }
        catch (Exception e) {
            if (retry > 0) {
                System.out.println("[!] Failed to generate image. Retrying...");
                return this.fetchImages(prompt, retry - 1);
            }
            throw new ImageFXError("Failed to generate image: " + e.getMessage());
        }
    }

    private static void applyAuthHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
        headers.forEach(builder::header);
    }

    private static JsonElement deepGet(JsonObject root, String ... path) {
        JsonObject cur = root;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (cur == null || !cur.isJsonObject()) {
                return null;
            }
            cur = cur.getAsJsonObject().get(key);
            ++n2;
        }
        return cur;
    }

    private static PromptArg buildPromptArg(String prompt) {
        PromptArg a = new PromptArg();
        a.prompt = prompt;
        return a;
    }
}

